/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.services.api.ITransactionService;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IPayload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/transaction"})
public class TransactionController {
    private static final Logger LOG = LogManager.getLogger(TransactionController.class);
    @Autowired
    private ITransactionService transactionService;

    @PostMapping(value={"/{transactionId}"})
    public ResponseEntity<IPayload> write(@PathVariable(value="transactionId") UUID transactionId, @RequestParam(value="file") MultipartFile file) {
        IPayload payload;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("START write transaction %s", transactionId));
        }
        if ((payload = this.transactionService.writeTransaction(transactionId, file)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Write transaction %s failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), transactionId, errorPayload.message()));
            return new ResponseEntity((Object)payload, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Write transaction %s successful", SecurityContextHolder.getContext().getAuthentication().getName(), transactionId));
        }
        return new ResponseEntity((Object)payload, (HttpStatusCode)HttpStatus.OK);
    }
}

