/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.attachments;

import fr.obeo.perseus.server.model.domain.boundedcontexts.extattachment.services.ExtAttachmentDescriptor;
import fr.obeo.perseus.server.model.domain.boundedcontexts.extattachment.services.api.IExtAttachmentSearchService;
import fr.obeo.perseus.server.services.api.model.ModelSummary;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@QueryDataFetcher(type="ModelSummary", field="unsynchronizedAttachments")
public class ModelSummaryUnsynchronizedAttachmentsDataFetcher
implements IDataFetcherWithFieldCoordinates<Collection<ExtAttachmentDescriptor>> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelSummaryUnsynchronizedAttachmentsDataFetcher.class);
    private final IExtAttachmentSearchService extAttachmentSearchService;

    public ModelSummaryUnsynchronizedAttachmentsDataFetcher(IExtAttachmentSearchService extAttachmentSearchService) {
        this.extAttachmentSearchService = Objects.requireNonNull(extAttachmentSearchService);
    }

    public List<ExtAttachmentDescriptor> get(DataFetchingEnvironment environment) throws Exception {
        ModelSummary modelSummary = (ModelSummary)environment.getSource();
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - GraphQL Query ModelSummary/unsynchronizedAttachments issued for model '%s' (id=%d)", SecurityContextHolder.getContext().getAuthentication().getName(), modelSummary.getName(), Long.valueOf(modelSummary.getUid())));
        }
        return this.extAttachmentSearchService.getUnsynchronizedAttachments(Long.valueOf(modelSummary.getUid()).longValue());
    }
}

