/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.attachments;

import fr.obeo.perseus.server.dto.model.ModelDTO;
import fr.obeo.perseus.server.model.domain.boundedcontexts.extattachment.services.ExtAttachmentArtifactDescriptor;
import fr.obeo.perseus.server.model.domain.boundedcontexts.extattachment.services.api.IExtAttachmentSearchService;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@QueryDataFetcher(type="Model", field="unsynchronizedAttachmentArtifacts")
public class ModelUnsynchronizedAttachmentArtifactsDataFetcher
implements IDataFetcherWithFieldCoordinates<Collection<ExtAttachmentArtifactDescriptor>> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelUnsynchronizedAttachmentArtifactsDataFetcher.class);
    private final IExtAttachmentSearchService extAttachmentSearchService;

    public ModelUnsynchronizedAttachmentArtifactsDataFetcher(IExtAttachmentSearchService extAttachmentSearchService) {
        this.extAttachmentSearchService = Objects.requireNonNull(extAttachmentSearchService);
    }

    public List<ExtAttachmentArtifactDescriptor> get(DataFetchingEnvironment environment) throws Exception {
        ModelDTO model = (ModelDTO)environment.getSource();
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - GraphQL Query Model/unsynchronizedAttachmentArtifacts issued for model '%s' (id=%d)", SecurityContextHolder.getContext().getAuthentication().getName(), model.getName(), model.getId()));
        }
        return this.extAttachmentSearchService.getUnsynchronizedAttachmentArtifacts(model.getId());
    }
}

