/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.editingContext;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.GQLModelObjectRef;
import fr.obeo.perseus.server.common.services.api.ILabelProvider;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshot;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.BasicModelObjectID;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CommitBreadcrumbsDataFetcherDelegate {
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final ILabelProvider<ModelObjectSnapshot> modelObjectSnapshotLabelProvider;

    public CommitBreadcrumbsDataFetcherDelegate(IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, ILabelProvider<ModelObjectSnapshot> modelObjectSnapshotLabelProvider) {
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.modelObjectSnapshotLabelProvider = Objects.requireNonNull(modelObjectSnapshotLabelProvider);
    }

    public List<GQLModelObjectRef> get(CommitEditingContext editingContext, Number modelId, String objectId) {
        Optional optSnapshot = this.modelObjectSnapshotSearchService.findModelObjectInCommit((IModelObjectID)new BasicModelObjectID(editingContext.getProjectId(), modelId.longValue(), objectId), editingContext.getCommit());
        HashSet parentIds = new HashSet();
        return optSnapshot.map(snapshot -> {
            ArrayList<GQLModelObjectRef> result = new ArrayList<GQLModelObjectRef>();
            String parentId = Optional.ofNullable(snapshot.getDerived()).flatMap(DerivedModelObjectData::getParentId).orElse(null);
            while (parentId != null && parentIds.add(parentId)) {
                BasicModelObjectID parentMoID = new BasicModelObjectID(editingContext.getProjectId(), modelId.longValue(), parentId);
                Optional optParentSnapshot = this.modelObjectSnapshotSearchService.findModelObjectInCommit((IModelObjectID)parentMoID, editingContext.getCommit());
                if (optParentSnapshot.isPresent()) {
                    ModelObjectSnapshot parentSnapshot = (ModelObjectSnapshot)optParentSnapshot.get();
                    result.add(0, GQLModelObjectRef.builder().setObjectId(parentId).setName(this.modelObjectSnapshotLabelProvider.getName((Object)parentSnapshot)).setType(parentSnapshot.getIntrinsic().getMetaclass()).setImageURL(this.modelObjectSnapshotLabelProvider.getIconURI((Object)parentSnapshot).toString()).build());
                    parentId = Optional.ofNullable(parentSnapshot.getDerived()).flatMap(DerivedModelObjectData::getParentId).orElse(null);
                    continue;
                }
                parentId = null;
            }
            return result;
        }).orElseGet(List::of);
    }
}

