/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.editingContext;

import fr.obeo.perseus.server.IModelObject;
import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.app.data.GQLModelObjectRef;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.meta.services.MetamodelRegistry;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.api.IIconService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ProjectModelObjectsDataFetcherDelegate {
    private final IModelObjectRepository modelObjectRepo;
    private final MetamodelRegistry mmRegistry;
    private final IIconService iconService;

    public ProjectModelObjectsDataFetcherDelegate(IModelObjectRepository modelObjectRepo, MetamodelRegistry mmRegistry, IIconService iconService) {
        this.modelObjectRepo = Objects.requireNonNull(modelObjectRepo);
        this.mmRegistry = Objects.requireNonNull(mmRegistry);
        this.iconService = Objects.requireNonNull(iconService);
    }

    public List<GQLModelObjectRef> get(ProjectEditingContext editingContext, List<String> uids, Number modelId) {
        List modelObjects = this.modelObjectRepo.loadModelObjectSummariesByUids(modelId.longValue(), uids, false);
        ArrayList<GQLModelObjectRef> result = new ArrayList<GQLModelObjectRef>();
        for (IModelObject mo : modelObjects) {
            GQLModelObjectRef.GQLModelObjectRefBuilder builder = GQLModelObjectRef.builder();
            Optional<Object> optSemanticTarget = Optional.empty();
            MetaclassDTO type = this.mmRegistry.getMetaclassByUid(mo.getMetaclassUid()).orElseGet(MetaclassDTO::unknown);
            if (this.mmRegistry.isRepresentationDescriptor(type)) {
                optSemanticTarget = this.modelObjectRepo.getChildren(new ModelObjectID(mo.getModelUid(), mo.getUid())).stream().filter(child -> this.mmRegistry.getMetaclassByUid(child.getMetaclassUid()).filter(arg_0 -> ((MetamodelRegistry)this.mmRegistry).isRepresentation(arg_0)).isPresent()).findFirst();
            }
            MetaclassDTO metaclassForIcon = type;
            if (optSemanticTarget.isPresent()) {
                IModelObject semanticTarget = (IModelObject)optSemanticTarget.get();
                metaclassForIcon = (MetaclassDTO)this.mmRegistry.getMetaclassByUid(semanticTarget.getMetaclassUid()).orElseThrow();
            }
            GQLModelObjectRef summary = builder.setObjectId(mo.getUid()).setName(mo.getName()).setType(new MetaclassQName(type.getName(), type.getMetamodelURI().toString())).setImageURL("/api/images" + this.iconService.getIconPath(mo.getIconHash(), metaclassForIcon.getName())).build();
            result.add(summary);
        }
        return result;
    }
}

