/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.monitoring;

import fr.obeo.ocp.domain.boundedcontexts.account.repositories.IAccountRepository;
import fr.obeo.perseus.server.app.data.GlobalMetricsResponse;
import fr.obeo.perseus.server.repositories.IMOExtResourceRepository;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.repositories.IModelRepository;
import java.util.List;
import org.eclipse.sirius.web.domain.boundedcontexts.project.repositories.IProjectRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/metrics"})
public class MetricsController {
    private final IAccountRepository accountRepository;
    private final IProjectRepository projectRepository;
    private final IModelRepository modelRepository;
    private final IModelObjectRepository modelObjectRepository;
    private final IMOExtResourceRepository moExtResourceRepository;

    public MetricsController(@Autowired IAccountRepository accountRepository, @Autowired IProjectRepository projectRepository, @Autowired IModelRepository modelRepository, @Autowired IModelObjectRepository modelObjectRepository, @Autowired IMOExtResourceRepository imoExtResourceRepository) {
        this.accountRepository = accountRepository;
        this.projectRepository = projectRepository;
        this.modelRepository = modelRepository;
        this.modelObjectRepository = modelObjectRepository;
        this.moExtResourceRepository = imoExtResourceRepository;
    }

    @GetMapping(value={"/global"})
    @PreAuthorize(value="isAuthenticated() && hasRole('Server Admin')")
    public GlobalMetricsResponse info() {
        GlobalMetricsResponse result = new GlobalMetricsResponse();
        List accounts = this.accountRepository.findAll();
        long activeAccountCount = accounts.stream().filter(u -> u.isEnabled()).count();
        long inactiveAccountCount = (long)accounts.size() - activeAccountCount;
        result.setNbActiveAccount(Long.valueOf(activeAccountCount));
        result.setNbInactiveAccount(Long.valueOf(inactiveAccountCount));
        long nbProject = this.projectRepository.count();
        result.setNbProject(Long.valueOf(nbProject));
        result.setSumModel(Long.valueOf(this.modelRepository.count()));
        result.setNbMaxModel(this.modelRepository.getMaxNumberOfModel().orElse(0L));
        result.setSumObject(Long.valueOf(this.modelObjectRepository.count()));
        result.setNbMaxObject(this.modelObjectRepository.getMaxNumberOfObject().orElse(0L));
        result.setSumImoExtResources(Long.valueOf(this.moExtResourceRepository.count()));
        result.setNbMaxImoExtResources(this.moExtResourceRepository.getMaxNumberOfMOExtResource().orElse(0L));
        return result;
    }
}

