/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.mutation;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.ITransactionService;
import fr.obeo.perseus.server.services.api.transactions.graphql.CancelTransactionInput;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.MutationDataFetcher;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@MutationDataFetcher(type="Mutation", field="cancelTransaction")
public class MutationCancelTransactionDataFetcher
implements IDataFetcherWithFieldCoordinates<IPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(MutationCancelTransactionDataFetcher.class);
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final ITransactionService transactionService;

    public MutationCancelTransactionDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, ITransactionService transactionService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.transactionService = transactionService;
    }

    public IPayload get(DataFetchingEnvironment environment) throws Exception {
        IPayload payload;
        Object argument = environment.getArgument("input");
        CancelTransactionInput input = (CancelTransactionInput)this.objectMapper.convertValue(argument, CancelTransactionInput.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to cancel transaction '%s' submitted", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), input.transactionId()));
        }
        if ((payload = this.exceptionWrapper.wrap(() -> this.transactionService.cancelTransaction(input), (IInput)input)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Request '%s' to cancel transaction '%s' failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), input.transactionId(), errorPayload));
        } else if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to cancel transaction '%s' successful: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), input.transactionId(), payload));
        }
        return payload;
    }
}

