/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.mutation;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.dto.versioning.DeleteBaselineSuccessPayload;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.versioning.IHistory;
import fr.obeo.perseus.server.versioning.api.DeleteBaselineInput;
import fr.obeo.perseus.server.versioning.api.IBaselineDeletionService;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.MutationDataFetcher;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.events.ICause;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.eclipse.sirius.web.domain.services.Failure;
import org.eclipse.sirius.web.domain.services.IResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@MutationDataFetcher(type="Mutation", field="deleteBaseline")
public class MutationDeleteBaselineDataFetcher
implements IDataFetcherWithFieldCoordinates<IPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(MutationDeleteBaselineDataFetcher.class);
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final IBaselineDeletionService baselineDeletionService;

    public MutationDeleteBaselineDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, IHistoryOfModelSearchService historyOfModelSearchService, IBaselineDeletionService baselineDeletionService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.baselineDeletionService = Objects.requireNonNull(baselineDeletionService);
    }

    public IPayload get(DataFetchingEnvironment environment) throws Exception {
        IPayload payload;
        Object argument = environment.getArgument("input");
        fr.obeo.perseus.server.services.api.dto.versioning.DeleteBaselineInput input = (fr.obeo.perseus.server.services.api.dto.versioning.DeleteBaselineInput)this.objectMapper.convertValue(argument, fr.obeo.perseus.server.services.api.dto.versioning.DeleteBaselineInput.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to delete a new baseline submitted", SecurityContextHolder.getContext().getAuthentication().getName(), input.id()));
        }
        if ((payload = this.exceptionWrapper.wrap(() -> this.deleteBaseline(input), (IInput)input)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Request '%s' to delete a new baseline failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), errorPayload));
        } else if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to delete a new baseline successful: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), payload));
        }
        return payload;
    }

    private IPayload deleteBaseline(fr.obeo.perseus.server.services.api.dto.versioning.DeleteBaselineInput input) {
        DeleteBaselineInput deleteTagInput;
        IHistory history = (IHistory)this.historyOfModelSearchService.findModelHistory(input.projectId(), input.modelId()).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find a History for model with id %d in the project '%s'", input.modelId(), input.projectId())));
        IResult result = this.baselineDeletionService.deleteBaseline(history, deleteTagInput = DeleteBaselineInput.forId((UUID)input.id()).withBaselineId(input.baselineId()).withCausedBy((ICause)input).build());
        if (result instanceof Failure) {
            Failure fail = (Failure)result;
            return new ErrorPayload(input.id(), fail.message());
        }
        return new DeleteBaselineSuccessPayload(input.id());
    }
}

