/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.mutation;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.graphql.UploadIconsInput;
import fr.obeo.perseus.server.services.api.graphql.UploadIconsSuccessPayload;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.MutationDataFetcher;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@MutationDataFetcher(type="Mutation", field="uploadIcons")
public class MutationUploadIconsDataFetcher
implements IDataFetcherWithFieldCoordinates<IPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(MutationUploadIconsDataFetcher.class);
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final IIconService iconService;

    public MutationUploadIconsDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, IIconService iconService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.iconService = Objects.requireNonNull(iconService);
    }

    public IPayload get(DataFetchingEnvironment environment) throws Exception {
        IPayload payload;
        Object argument = environment.getArgument("input");
        UploadIconsInput input = (UploadIconsInput)this.objectMapper.convertValue(argument, UploadIconsInput.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to upload %d icons submitted", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), input.iconsData().size()));
        }
        if ((payload = this.exceptionWrapper.wrap(() -> {
            this.iconService.uploadIcons(input);
            return new UploadIconsSuccessPayload(input.id());
        }, (IInput)input)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Request '%s' to upload %d icons failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), input.iconsData().size(), errorPayload));
        } else if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to upload %d icons successful: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), input.iconsData().size(), payload));
        }
        return payload;
    }
}

