/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.model.ModelEventInput;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.SubscriptionDataFetcher;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IEventProcessorSubscriptionProvider;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.reactivestreams.Publisher;

@SubscriptionDataFetcher(type="Subscription", field="modelEvent")
public class SubscriptionModelEventDataFetcher
implements IDataFetcherWithFieldCoordinates<Publisher<IPayload>> {
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final IEventProcessorSubscriptionProvider eventProcessorSubscriptionProvider;

    public SubscriptionModelEventDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, IEventProcessorSubscriptionProvider eventProcessorSubscriptionProvider) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.eventProcessorSubscriptionProvider = Objects.requireNonNull(eventProcessorSubscriptionProvider);
    }

    public Publisher<IPayload> get(DataFetchingEnvironment environment) throws Exception {
        Object argument = environment.getArgument("input");
        ModelEventInput input = (ModelEventInput)this.objectMapper.convertValue(argument, ModelEventInput.class);
        return this.exceptionWrapper.wrapFlux(() -> this.eventProcessorSubscriptionProvider.getSubscription(input.editingContextId(), input.representationId(), (IInput)input), (IInput)input);
    }
}

