/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.SubscriptionDataFetcher;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IEventProcessorSubscriptionProvider;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.eclipse.sirius.web.application.project.dto.ProjectEventInput;
import org.eclipse.sirius.web.application.project.services.api.IProjectEditingContextService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@SubscriptionDataFetcher(type="Subscription", field="perseusProjectEvent")
public class SubscriptionPerseusProjectEventDataFetcher
implements IDataFetcherWithFieldCoordinates<Publisher<IPayload>> {
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final IEventProcessorSubscriptionProvider eventProcessorSubscriptionProvider;
    private final IProjectEditingContextService projectEditingContextService;

    public SubscriptionPerseusProjectEventDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, IEventProcessorSubscriptionProvider eventProcessorSubscriptionProvider, IProjectEditingContextService projectEditingContextService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.eventProcessorSubscriptionProvider = Objects.requireNonNull(eventProcessorSubscriptionProvider);
        this.projectEditingContextService = Objects.requireNonNull(projectEditingContextService);
    }

    public Publisher<IPayload> get(DataFetchingEnvironment environment) throws Exception {
        Object argument = environment.getArgument("input");
        ProjectEventInput input = (ProjectEventInput)this.objectMapper.convertValue(argument, ProjectEventInput.class);
        return (Publisher)this.projectEditingContextService.getEditingContextId(input.projectId()).map(editingContextId -> this.exceptionWrapper.wrapFlux(() -> this.eventProcessorSubscriptionProvider.getSubscription(editingContextId, input.projectId().toString(), (IInput)input), (IInput)input)).orElse(Flux.empty());
    }
}

