/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.data;

import fr.obeo.perseus.server.app.data.FullCommitID;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshotNode;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.ICommit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.representations.IRepresentationDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommitEditingContext
implements IEditingContext {
    private static final String SEGMENT_COMMIT = "commit";
    private static final Logger LOG = LoggerFactory.getLogger(CommitEditingContext.class);
    private final ICommit commit;
    private final FullCommitID fullCommitId;
    private final ModelSnapshotNode model;
    private final Map<String, IRepresentationDescription> representationDescriptions;

    public CommitEditingContext(String projectId, ICommit commit, ModelSnapshotNode model, Map<String, IRepresentationDescription> representationDescriptions) {
        this.commit = Objects.requireNonNull(commit);
        this.fullCommitId = new FullCommitID(projectId, commit.getId());
        this.model = Objects.requireNonNull(model);
        this.representationDescriptions = Objects.requireNonNull(representationDescriptions);
    }

    public String getId() {
        return CommitEditingContext.toParsableString((FullCommitID)this.fullCommitId);
    }

    public FullCommitID getFullCommitId() {
        return this.fullCommitId;
    }

    public String getProjectId() {
        return this.fullCommitId.projectId();
    }

    public ICommit getCommit() {
        return this.commit;
    }

    public ModelSnapshotNode getModel() {
        return this.model;
    }

    public Map<String, IRepresentationDescription> getRepresentationDescriptions() {
        return this.representationDescriptions;
    }

    public static Optional<FullCommitID> parseCommitId(String editingContextId) {
        String[] segments = editingContextId.split("/");
        if (segments.length == 4 && "commit".equals(segments[0])) {
            try {
                return Optional.of(new FullCommitID(segments[1], new CommitID(UUID.fromString(segments[2]), Integer.parseInt(segments[3]))));
            }
            catch (IllegalArgumentException e) {
                LOG.warn(String.format("The editing context id '%s' cannot be interpreted as a CommitID.", editingContextId));
            }
        }
        return Optional.empty();
    }

    public static String toParsableString(FullCommitID fullCommitId) {
        return String.format("commit/%s/%s/%d", fullCommitId.projectId(), fullCommitId.commitId().getBranchId().toString(), fullCommitId.commitId().getVersion());
    }

    public String toString() {
        return String.format("CommitEditingContext projectId='%s', commitId='%s'", this.fullCommitId.projectId(), this.fullCommitId.commitId());
    }
}

