/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.graphql;

import fr.obeo.perseus.server.common.auth.AuthenticationRequired;
import fr.obeo.perseus.server.common.auth.BasicAuthenticationChallenge;
import fr.obeo.perseus.server.common.auth.IAuthenticationChallenge;
import fr.obeo.perseus.server.jama.app.graphql.ApiKeyGraphQLError;
import fr.obeo.perseus.server.jama.domain.auth.ApiKeyAuthenticationChallenge;
import fr.obeo.perseus.server.oauth.api.OAuth1AuthenticationChallenge;
import fr.obeo.perseus.server.oauth.app.auth.BasicAuthGraphQLError;
import fr.obeo.perseus.server.oauth.app.auth.OAuthTokenGraphQLError;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sirius.web.infrastructure.configuration.graphql.GraphQLDataFetcherExceptionHandler;

public class AuthRequiredDataFetcherExceptionHandler
extends GraphQLDataFetcherExceptionHandler {
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable t = handlerParameters.getException();
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getCause();
        }
        if (t instanceof AuthenticationRequired) {
            AuthenticationRequired e = (AuthenticationRequired)t;
            IAuthenticationChallenge challenge = e.getChallenge();
            if (challenge instanceof OAuth1AuthenticationChallenge) {
                OAuth1AuthenticationChallenge oauth1Challenge = (OAuth1AuthenticationChallenge)challenge;
                OAuthTokenGraphQLError error = new OAuthTokenGraphQLError(e.getMessage(), oauth1Challenge.userAuthorizationURL(), handlerParameters.getSourceLocation());
                DataFetcherExceptionHandlerResult result = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build();
                return CompletableFuture.completedFuture(result);
            }
            if (challenge instanceof BasicAuthenticationChallenge) {
                BasicAuthenticationChallenge basicChallenge = (BasicAuthenticationChallenge)challenge;
                BasicAuthGraphQLError error = new BasicAuthGraphQLError(e.getMessage(), e.getFriend().key(), basicChallenge.realm(), handlerParameters.getSourceLocation());
                DataFetcherExceptionHandlerResult result = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build();
                return CompletableFuture.completedFuture(result);
            }
            if (challenge instanceof ApiKeyAuthenticationChallenge) {
                ApiKeyAuthenticationChallenge apiKeyChallenge = (ApiKeyAuthenticationChallenge)challenge;
                ApiKeyGraphQLError error = new ApiKeyGraphQLError(apiKeyChallenge.message(), e.getFriend().key(), apiKeyChallenge.serverUrl(), handlerParameters.getSourceLocation());
                DataFetcherExceptionHandlerResult result = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build();
                return CompletableFuture.completedFuture(result);
            }
        }
        return super.handleException(handlerParameters);
    }
}

