/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.graphql;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class GraphQLAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authEx) throws IOException {
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealmName() + "\"");
        response.setStatus(401);
        PrintWriter writer = response.getWriter();
        writer.print("{\"authenticated\":false,\"message\":\"");
        if (authEx == null || authEx.getMessage() == null) {
            writer.print("<no message>");
        } else {
            writer.print(authEx.getMessage().replace("\\", "\\\\").replace("\"", "\\\""));
        }
        writer.println("\"}");
    }

    public void afterPropertiesSet() {
        this.setRealmName("Perseus API");
        super.afterPropertiesSet();
    }
}

