/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.licenses;

import fr.obeo.ocp.application.license.dto.AssignTokenInput;
import fr.obeo.ocp.application.license.services.api.IPrivilegeApplicationService;
import fr.obeo.ocp.application.license.services.api.ITokenApplicationService;
import fr.obeo.ocp.domain.boundedcontexts.account.IOCPUser;
import fr.obeo.ocp.domain.boundedcontexts.account.services.api.IAccountSearchService;
import fr.obeo.ocp.domain.boundedcontexts.license.Token;
import fr.obeo.ocp.domain.boundedcontexts.license.TokenPrivilege;
import fr.obeo.ocp.domain.boundedcontexts.license.repositories.IPrivilegeRepository;
import fr.obeo.ocp.domain.boundedcontexts.license.services.api.ILicenseSearchService;
import fr.obeo.ocp.domain.boundedcontexts.license.services.api.ITokenSearchService;
import fr.obeo.ocp.infrastructure.security.OCPOidcUser;
import fr.obeo.ocp.infrastructure.security.OCPUser;
import fr.obeo.perseus.server.common.security.PerseusSystemUser;
import java.security.Principal;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="perseus.license", name={"auto.assign.read.on.login"}, havingValue="true")
public class AssignReadLicenseOnLogin {
    private static final Logger LOG = LoggerFactory.getLogger(AssignReadLicenseOnLogin.class);
    private final ILicenseSearchService licenseSearchService;
    private final IPrivilegeApplicationService privilegeApplicationService;
    private final IPrivilegeRepository privilegeRepository;
    private final ITokenSearchService tokenSearchService;
    private final ITokenApplicationService tokenApplicationService;
    private final IAccountSearchService accountSearchService;

    public AssignReadLicenseOnLogin(ILicenseSearchService licenseSearchService, IPrivilegeApplicationService privilegeApplicationService, IPrivilegeRepository privilegeRepository, ITokenSearchService tokenSearchService, ITokenApplicationService tokenApplicationService, IAccountSearchService accountSearchService) {
        this.licenseSearchService = Objects.requireNonNull(licenseSearchService);
        this.privilegeApplicationService = Objects.requireNonNull(privilegeApplicationService);
        this.privilegeRepository = Objects.requireNonNull(privilegeRepository);
        this.tokenSearchService = Objects.requireNonNull(tokenSearchService);
        this.tokenApplicationService = Objects.requireNonNull(tokenApplicationService);
        this.accountSearchService = Objects.requireNonNull(accountSearchService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onLogin(AuthenticationSuccessEvent event) {
        Object principal = event.getAuthentication().getPrincipal();
        if (principal instanceof OCPUser || principal instanceof OCPOidcUser) {
            IOCPUser ocpUser = (IOCPUser)principal;
            if (!event.getAuthentication().getAuthorities().stream().anyMatch(ga -> "ROLE_Server Admin".equals(ga.getAuthority()))) {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                try {
                    List privileges;
                    this.accountSearchService.findByUsername("system").ifPresent(systemAccount -> {
                        UsernamePasswordAuthenticationToken systemAuthentication = new UsernamePasswordAuthenticationToken((Object)new PerseusSystemUser(systemAccount.getId()), List.of(), List.of(new SimpleGrantedAuthority("ROLE_Server Admin")));
                        SecurityContextHolder.getContext().setAuthentication((Authentication)systemAuthentication);
                    });
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("%s - Received AuthenticationSuccessEvent, checking if 'Read' privilege is missing and can be automatically assigned.", ocpUser.getUsername()));
                    }
                    if ((privileges = this.privilegeApplicationService.findAllByAccountId(ocpUser.getAccountId())).isEmpty()) {
                        this.onLoginWithNoPrivilege(ocpUser);
                    }
                }
                finally {
                    SecurityContextHolder.getContext().setAuthentication(authentication);
                }
            }
        }
    }

    private void onLoginWithNoPrivilege(IOCPUser ocpUser) {
        IPayload payload = this.privilegeRepository.findAll().stream().filter(priv -> "Read".equals(priv.getName())).findFirst().map(readPrivilege -> this.onLoginWithNoPrivilege(ocpUser, readPrivilege.getId())).orElseGet(() -> this.noTokenAvailableErrorPayload(ocpUser));
        if (payload instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Received AuthenticationSuccessEvent, assigning 'Read' privilege on newly created account '%s' for user '%s' failed: %s", Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Principal::getName).orElse(ocpUser.getUsername()), ocpUser.getAccountId(), ocpUser.getUsername(), errorPayload.message()));
        } else {
            LOG.info(String.format("%s - Received AuthenticationSuccessEvent, assigning 'Read' privilege on newly created account '%s' for user '%s' successful.", ocpUser.getUsername(), ocpUser.getAccountId(), ocpUser.getUsername()));
        }
    }

    private IPayload onLoginWithNoPrivilege(IOCPUser ocpUser, String readPrivilegeID) {
        Page allLicenses = this.licenseSearchService.findAll(Pageable.unpaged());
        return allLicenses.stream().flatMap(lic -> this.tokenSearchService.findAllByLicenseId(lic.getId()).stream()).filter(token -> this.tokenHasOnlyPrivilege(token, readPrivilegeID)).filter(arg_0 -> this.tokenCanBeAssigned(arg_0)).findFirst().map(availableToken -> this.tokenApplicationService.assignToken(new AssignTokenInput(UUID.randomUUID(), availableToken.getId(), ocpUser.getUsername()))).orElseGet(() -> this.noTokenAvailableErrorPayload(ocpUser));
    }

    private boolean tokenCanBeAssigned(Token token) {
        Instant now = Instant.now();
        return token.getAssignments().size() < token.getTotalTokenCount() && token.getStartDate().isBefore(now) && token.getEndDate().isAfter(now);
    }

    private boolean tokenHasOnlyPrivilege(Token token, String readPrivilegeID) {
        return token.getPrivileges().size() == 1 && readPrivilegeID.equals(((TokenPrivilege)token.getPrivileges().iterator().next()).getPrivilege().getId());
    }

    private ErrorPayload noTokenAvailableErrorPayload(IOCPUser ocpUser) {
        return new ErrorPayload(UUID.randomUUID(), String.format("%s - No token with privilege 'Read' is available. User can log in but will not be able to access or edit any information on the server.", ocpUser.getUsername()));
    }
}

