/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.IModel;
import fr.obeo.perseus.server.app.services.versioning.BaselineCreatedInput;
import fr.obeo.perseus.server.app.services.versioning.BaselineDeletedInput;
import fr.obeo.perseus.server.app.services.versioning.NewCommitInput;
import fr.obeo.perseus.server.oslc.api.graphql.ForceDeleteModelOslcLinksInput;
import fr.obeo.perseus.server.oslc.api.graphql.RetryOslcLinksInput;
import fr.obeo.perseus.server.oslc.globalconf.api.graphql.AssignModelGlobalConfInput;
import fr.obeo.perseus.server.oslc.services.OslcLinkService;
import fr.obeo.perseus.server.repositories.IModelRepository;
import fr.obeo.perseus.server.services.api.BaselineCreatedEventPayload;
import fr.obeo.perseus.server.services.api.BaselineDeletedEventPayload;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.NewCommitEventPayload;
import fr.obeo.perseus.server.services.api.attachments.DeleteExtAttachmentsInput;
import fr.obeo.perseus.server.services.api.attachments.RetryUnsynchronizedAttachmentsInput;
import fr.obeo.perseus.server.services.api.dto.versioning.CommitDTO;
import fr.obeo.perseus.server.services.api.model.ModelRefreshedEventPayload;
import fr.obeo.perseus.server.services.api.model.ModelSaveInput;
import fr.obeo.perseus.server.services.api.model.ModelSummary;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import fr.obeo.perseus.server.versioning.repositories.IResourceStateRepository;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.sirius.components.collaborative.api.ChangeDescription;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManager;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.core.api.IRepresentationInput;
import org.eclipse.sirius.components.representations.IRepresentation;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelEventProcessor
implements IRepresentationEventProcessor {
    private final Logger logger = LoggerFactory.getLogger(ModelEventProcessor.class);
    private final String projectId;
    private final long modelId;
    private final ISubscriptionManager subscriptionManager;
    private final Sinks.Many<IPayload> sink = Sinks.many().multicast().directBestEffort();
    private final AtomicReference<ModelSummary> currentSummary = new AtomicReference();
    private final IModelRepository modelRepository;
    private final IIconService iconService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final ICommitSearchService commitSearchService;
    private final ModelEntityToDTO entityToDTO;
    private final IResourceStateRepository resourceStateRepository;

    public ModelEventProcessor(IModelRepository modelRepository, String projectId, long modelId, ISubscriptionManager subscriptionManager, IIconService iconService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IHistoryOfModelSearchService historyOfModelSearchService, ICommitSearchService commitSearchService, ModelEntityToDTO entityToDTO, IResourceStateRepository resourceStateRepository) {
        this.logger.trace("Creating the model event processor {}", (Object)modelId);
        this.modelRepository = Objects.requireNonNull(modelRepository);
        this.projectId = Objects.requireNonNull(projectId);
        this.modelId = Objects.requireNonNull(modelId);
        this.subscriptionManager = Objects.requireNonNull(subscriptionManager);
        this.iconService = Objects.requireNonNull(iconService);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
        this.resourceStateRepository = Objects.requireNonNull(resourceStateRepository);
        ModelSummary summary = this.refreshSummary();
        this.currentSummary.set(summary);
    }

    public IRepresentation getRepresentation() {
        return (IRepresentation)this.currentSummary.get();
    }

    public ISubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void handle(Sinks.One<IPayload> payloadSink, Sinks.Many<ChangeDescription> changeDescriptionSink, IRepresentationInput representationInput) {
    }

    public void refresh(ChangeDescription changeDescription) {
        Optional<ModelRefreshedEventPayload> optPayload = Optional.empty();
        if ("SEMANTIC_CHANGE".equals(changeDescription.getKind()) || "LINK_CHANGE".equals(changeDescription.getKind()) || "ATTACHMENT_CHANGE".equals(changeDescription.getKind())) {
            IInput input = changeDescription.getInput();
            boolean related = true;
            if (input instanceof ModelSaveInput) {
                ModelSaveInput modelSaveInput = (ModelSaveInput)input;
                related = modelSaveInput.modelUpdate().getModelDTO().getId() == this.modelId;
            } else if (input instanceof AssignModelGlobalConfInput) {
                AssignModelGlobalConfInput assignModelGlobalConfInput = (AssignModelGlobalConfInput)input;
                related = assignModelGlobalConfInput.modelId() == this.modelId;
            } else if (input instanceof OslcLinkService.ModelSaveInputAdapter) {
                OslcLinkService.ModelSaveInputAdapter modelSaveInputAdapter = (OslcLinkService.ModelSaveInputAdapter)input;
                related = modelSaveInputAdapter.modelId() == this.modelId;
            } else if (input instanceof ForceDeleteModelOslcLinksInput) {
                ForceDeleteModelOslcLinksInput forceDeleteModelOslcLinksInput = (ForceDeleteModelOslcLinksInput)input;
                related = forceDeleteModelOslcLinksInput.modelId() == this.modelId;
            } else if (input instanceof RetryOslcLinksInput) {
                RetryOslcLinksInput retryOslcLinksInput = (RetryOslcLinksInput)input;
                related = retryOslcLinksInput.modelId() == this.modelId;
            } else if (input instanceof RetryUnsynchronizedAttachmentsInput) {
                RetryUnsynchronizedAttachmentsInput retryUnsynchronizedAttachmentsInput = (RetryUnsynchronizedAttachmentsInput)input;
                related = retryUnsynchronizedAttachmentsInput.modelId() == this.modelId;
            } else if (input instanceof DeleteExtAttachmentsInput) {
                DeleteExtAttachmentsInput deleteExtAttachmentsInput = (DeleteExtAttachmentsInput)input;
                boolean bl = related = deleteExtAttachmentsInput.modelId() == this.modelId;
            }
            if (related) {
                ModelSummary summary = this.refreshSummary();
                this.currentSummary.set(summary);
                optPayload = Optional.ofNullable(new ModelRefreshedEventPayload(input.id(), summary));
            }
        } else if ("HISTORY_CHANGE".equals(changeDescription.getKind())) {
            optPayload = this.refreshFromHistoryChange(changeDescription.getInput());
        }
        optPayload.ifPresent(payload -> {
            Sinks.EmitResult emitResult;
            if (this.sink.currentSubscriberCount() > 0 && (emitResult = this.sink.tryEmitNext(payload)).isFailure()) {
                String pattern = "An error has occurred while emitting a ModelRefreshedEventPayload: {}";
                this.logger.warn(pattern, (Object)emitResult);
            }
        });
    }

    private Optional<IPayload> refreshFromHistoryChange(IInput input) {
        BaselineDeletedInput baselineDeletedInput;
        Optional<IPayload> optPayload = Optional.empty();
        if (input instanceof NewCommitInput) {
            NewCommitInput newCommitInput = (NewCommitInput)input;
            if (this.resourceStateRepository.commitImpactsResource(String.format("%d/%%", this.modelId), '\\', newCommitInput.getCommitId())) {
                optPayload = this.findCommit(newCommitInput.getCommitId()).map(commit -> new NewCommitEventPayload(input.id(), commit));
            }
        } else if (input instanceof BaselineCreatedInput) {
            BaselineCreatedInput baselineCreatedInput = (BaselineCreatedInput)input;
            if (baselineCreatedInput.modelId() == this.modelId) {
                optPayload = Optional.ofNullable(new BaselineCreatedEventPayload(input.id(), baselineCreatedInput.baseline()));
            }
        } else if (input instanceof BaselineDeletedInput && (baselineDeletedInput = (BaselineDeletedInput)input).modelId() == this.modelId) {
            optPayload = Optional.ofNullable(new BaselineDeletedEventPayload(input.id(), baselineDeletedInput.baselineId()));
        }
        return optPayload;
    }

    private Optional<CommitDTO> findCommit(CommitID commitId) {
        return this.historyOfModelSearchService.findModelHistory(this.projectId, this.modelId).flatMap(history -> this.commitSearchService.findCommit(history, commitId)).map(arg_0 -> ((ModelEntityToDTO)this.entityToDTO).convert(arg_0));
    }

    private ModelSummary refreshSummary() {
        ModelSummary summary = null;
        Optional optionalModel = this.modelRepository.findByIdAndProjectId(this.modelId, this.projectId);
        if (optionalModel.isEmpty()) {
            summary = ModelSummary.builder((boolean)false).setUid(String.valueOf(this.modelId)).setProjectId(this.projectId).setName(this.modelAppMessageSourceAccessor.getMessage("unknown.model.name")).setDescription(this.modelAppMessageSourceAccessor.getMessage("unknown.model.desc")).setImageURL("/api/images/static/images/UnknownType.png").build();
        } else {
            IModel model = (IModel)optionalModel.get();
            String id = String.valueOf(model.getUid());
            String name = model.getName();
            String description = model.getDescription();
            String imageURL = "/api/images" + this.iconService.getModelIconPath(model.getIconHash());
            summary = ModelSummary.builder((boolean)true).setUid(id).setProjectId(this.projectId).setName(name).setDescription(description).setImageURL(imageURL).build();
        }
        return summary;
    }

    public Flux<IPayload> getOutputEvents(IInput input) {
        Mono initialRefresh = Mono.fromCallable(() -> new ModelRefreshedEventPayload(input.id(), (ModelSummary)this.currentSummary.get()));
        Flux refreshEventFlux = Flux.concat((Publisher[])new Publisher[]{initialRefresh, this.sink.asFlux()});
        return Flux.merge((Publisher[])new Publisher[]{refreshEventFlux, this.subscriptionManager.getFlux(input)});
    }

    public void dispose() {
        this.subscriptionManager.dispose();
        Sinks.EmitResult emitResult = this.sink.tryEmitComplete();
        if (emitResult.isFailure()) {
            String pattern = "An error has occurred while marking the publisher as complete: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }
}

