/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.IModelObject;
import fr.obeo.perseus.server.IModelObjectExtensionGetter;
import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.app.properties.ObjectFormMapping;
import fr.obeo.perseus.server.app.properties.PropertyMappingsDefinition;
import fr.obeo.perseus.server.app.services.versioning.BaselineCreatedInput;
import fr.obeo.perseus.server.app.services.versioning.BaselineDeletedInput;
import fr.obeo.perseus.server.app.services.versioning.NewCommitInput;
import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.meta.services.MetamodelRegistry;
import fr.obeo.perseus.server.oslc.api.graphql.ForceDeleteModelOslcLinksInput;
import fr.obeo.perseus.server.oslc.api.graphql.RetryOslcLinksInput;
import fr.obeo.perseus.server.oslc.globalconf.api.graphql.AssignModelGlobalConfInput;
import fr.obeo.perseus.server.oslc.services.OslcLinkService;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.HTMLSanitizer;
import fr.obeo.perseus.server.services.ModelObjectDiagramGetter;
import fr.obeo.perseus.server.services.api.BaselineCreatedEventPayload;
import fr.obeo.perseus.server.services.api.BaselineDeletedEventPayload;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.NewCommitEventPayload;
import fr.obeo.perseus.server.services.api.dto.versioning.CommitDTO;
import fr.obeo.perseus.server.services.api.model.ModelSaveInput;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.services.api.modelobject.ModelDiagram;
import fr.obeo.perseus.server.services.api.modelobject.ModelObjectRefreshedEventPayload;
import fr.obeo.perseus.server.services.api.modelobject.ModelObjectSummary;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import fr.obeo.perseus.server.versioning.repositories.IResourceStateRepository;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.sirius.components.collaborative.api.ChangeDescription;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManager;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.core.api.IRepresentationInput;
import org.eclipse.sirius.components.representations.IRepresentation;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelObjectEventProcessor
implements IRepresentationEventProcessor {
    private final Logger logger = LoggerFactory.getLogger(ModelObjectEventProcessor.class);
    private final long modelId;
    private final String modelObjectId;
    private final MetamodelRegistry mmRegistry;
    private final IModelObjectRepository modelObjectRepository;
    private final ISubscriptionManager subscriptionManager;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final Sinks.Many<IPayload> sink = Sinks.many().multicast().directBestEffort();
    private final AtomicReference<ModelObjectSummary> currentSummary = new AtomicReference();
    private final HTMLSanitizer htmlSanitizer;
    private final IUriProvider uriProvider;
    private final IIconService iconService;
    private final String projectId;
    private final PropertyMappingsDefinition propertyMappingsDefinition;
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final ICommitSearchService commitSearchService;
    private final ModelEntityToDTO entityToDTO;
    private final IResourceStateRepository resourceStateRepository;

    public ModelObjectEventProcessor(HTMLSanitizer htmlSanitizer, MetamodelRegistry mmRegistry, IModelObjectRepository modelObjectRepository, long modelId, String modelObjectId, ISubscriptionManager subscriptionManager, IUriProvider diagramUriProvider, String projectId, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService, PropertyMappingsDefinition propertyMappingsDefinition, IHistoryOfModelSearchService historyOfModelSearchService, ICommitSearchService commitSearchService, ModelEntityToDTO entityToDTO, IResourceStateRepository resourceStateRepository) {
        this.logger.trace("Creating the model object event processor {} {}", (Object)modelId, (Object)modelObjectId);
        this.htmlSanitizer = Objects.requireNonNull(htmlSanitizer);
        this.mmRegistry = Objects.requireNonNull(mmRegistry);
        this.modelObjectRepository = Objects.requireNonNull(modelObjectRepository);
        this.modelId = Objects.requireNonNull(modelId);
        this.modelObjectId = modelObjectId;
        this.subscriptionManager = Objects.requireNonNull(subscriptionManager);
        this.uriProvider = Objects.requireNonNull(diagramUriProvider);
        this.projectId = Objects.requireNonNull(projectId);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
        this.propertyMappingsDefinition = Objects.requireNonNull(propertyMappingsDefinition);
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.entityToDTO = Objects.requireNonNull(entityToDTO);
        this.resourceStateRepository = Objects.requireNonNull(resourceStateRepository);
        ModelObjectSummary summary = this.refreshSummary();
        this.currentSummary.set(summary);
    }

    public IRepresentation getRepresentation() {
        return (IRepresentation)this.currentSummary.get();
    }

    public ISubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void handle(Sinks.One<IPayload> payloadSink, Sinks.Many<ChangeDescription> changeDescriptionSink, IRepresentationInput representationInput) {
    }

    public void refresh(ChangeDescription changeDescription) {
        Optional<ModelObjectRefreshedEventPayload> optPayload = Optional.empty();
        if ("SEMANTIC_CHANGE".equals(changeDescription.getKind()) || "LINK_CHANGE".equals(changeDescription.getKind())) {
            IInput input = changeDescription.getInput();
            boolean related = true;
            if (input instanceof ModelSaveInput) {
                ModelSaveInput modelSaveInput = (ModelSaveInput)input;
                related = modelSaveInput.modelUpdate().getModelDTO().getId() == this.modelId;
            } else if (input instanceof AssignModelGlobalConfInput) {
                AssignModelGlobalConfInput assignModelGlobalConfInput = (AssignModelGlobalConfInput)input;
                related = assignModelGlobalConfInput.modelId() == this.modelId;
            } else if (input instanceof OslcLinkService.ModelSaveInputAdapter) {
                OslcLinkService.ModelSaveInputAdapter modelSaveInputAdapter = (OslcLinkService.ModelSaveInputAdapter)input;
                related = modelSaveInputAdapter.modelId() == this.modelId;
            } else if (input instanceof ForceDeleteModelOslcLinksInput) {
                ForceDeleteModelOslcLinksInput forceDeleteModelOslcLinksInput = (ForceDeleteModelOslcLinksInput)input;
                related = forceDeleteModelOslcLinksInput.modelId() == this.modelId;
            } else if (input instanceof RetryOslcLinksInput) {
                RetryOslcLinksInput retryOslcLinksInput = (RetryOslcLinksInput)input;
                boolean bl = related = retryOslcLinksInput.modelId() == this.modelId;
            }
            if (related) {
                ModelObjectSummary summary = this.refreshSummary();
                this.currentSummary.set(summary);
                optPayload = Optional.ofNullable(new ModelObjectRefreshedEventPayload(changeDescription.getInput().id(), summary));
            }
        } else if ("HISTORY_CHANGE".equals(changeDescription.getKind())) {
            optPayload = this.refreshFromHistoryChange(changeDescription.getInput());
        }
        optPayload.ifPresent(payload -> {
            Sinks.EmitResult emitResult;
            if (this.sink.currentSubscriberCount() > 0 && (emitResult = this.sink.tryEmitNext(payload)).isFailure()) {
                String pattern = "An error has occurred while emitting a ModelRefreshedEventPayload: {}";
                this.logger.warn(pattern, (Object)emitResult);
            }
        });
    }

    private Optional<IPayload> refreshFromHistoryChange(IInput input) {
        BaselineDeletedInput baselineDeletedInput;
        Optional<IPayload> optPayload = Optional.empty();
        if (input instanceof NewCommitInput) {
            NewCommitInput newCommitInput = (NewCommitInput)input;
            if (this.resourceStateRepository.commitImpactsResource(String.format("%d/_/%s", this.modelId, this.modelObjectId), '\\', newCommitInput.getCommitId())) {
                optPayload = this.findCommit(newCommitInput.getCommitId()).map(commit -> new NewCommitEventPayload(input.id(), commit));
            }
        } else if (input instanceof BaselineCreatedInput) {
            BaselineCreatedInput baselineCreatedInput = (BaselineCreatedInput)input;
            if (baselineCreatedInput.modelId() == this.modelId) {
                optPayload = Optional.ofNullable(new BaselineCreatedEventPayload(input.id(), baselineCreatedInput.baseline()));
            }
        } else if (input instanceof BaselineDeletedInput && (baselineDeletedInput = (BaselineDeletedInput)input).modelId() == this.modelId) {
            optPayload = Optional.ofNullable(new BaselineDeletedEventPayload(input.id(), baselineDeletedInput.baselineId()));
        }
        return optPayload;
    }

    private Optional<CommitDTO> findCommit(CommitID commitId) {
        return this.historyOfModelSearchService.findModelHistory(this.projectId, this.modelId).flatMap(history -> this.commitSearchService.findCommit(history, commitId)).map(arg_0 -> ((ModelEntityToDTO)this.entityToDTO).convert(arg_0));
    }

    private ModelObjectSummary refreshSummary() {
        Optional optMO = this.modelObjectRepository.findById((Object)new ModelObjectID(this.modelId, this.modelObjectId));
        ModelObjectSummary.ModelObjectSummaryBuilder builder = ModelObjectSummary.builder().setUid(this.modelObjectId).setProjectId(this.projectId).setModelUid(this.modelId);
        if (optMO.isEmpty()) {
            builder.setName(this.modelAppMessageSourceAccessor.getMessage("unknown.object.name")).setType(new MetaclassQName(MetaclassDTO.unknown().getName(), MetaclassDTO.unknown().getMetamodelURI().toString())).setDescription(this.modelAppMessageSourceAccessor.getMessage("unknown.object.desc")).setImageURL("/api/images/static/images/UnknownType.png").build();
        } else {
            IModelObject target = (IModelObject)optMO.get();
            builder.setName(Optional.ofNullable(target.getName()).orElse("<Unnamed>"));
            Optional<Object> optSemanticTarget = Optional.empty();
            MetaclassDTO type = this.mmRegistry.getMetaclassByUid(target.getMetaclassUid()).orElseGet(MetaclassDTO::unknown);
            if (this.mmRegistry.isRepresentationDescriptor(type)) {
                optSemanticTarget = this.modelObjectRepository.getChildren(new ModelObjectID(target.getModelUid(), target.getUid())).stream().filter(child -> this.mmRegistry.getMetaclassByUid(child.getMetaclassUid()).filter(arg_0 -> ((MetamodelRegistry)this.mmRegistry).isRepresentation(arg_0)).isPresent()).findFirst();
            }
            if (optSemanticTarget.isPresent()) {
                IModelObject semanticTarget = (IModelObject)optSemanticTarget.get();
                MetaclassDTO semanticType = (MetaclassDTO)this.mmRegistry.getMetaclassByUid(semanticTarget.getMetaclassUid()).orElseThrow();
                builder.setImageURL("/api/images" + this.iconService.getIconPath(semanticTarget.getIconHash(), semanticType.getName())).setDescription(this.computeDescription(semanticTarget, semanticType)).setType(new MetaclassQName(semanticType.getName(), semanticType.getMetamodelURI().toString()));
                try {
                    builder.setObjectDiagram((ModelDiagram)((IModelObject)optSemanticTarget.get()).accept((IModelObjectExtensionGetter)new ModelObjectDiagramGetter(this.projectId, target.getModelUid(), this.uriProvider)).orElse(null));
                }
                catch (RuntimeException e) {
                    this.logger.error("Error while reading image & image map for object {}/{}: {}", new Object[]{this.modelId, this.modelObjectId, e});
                }
            } else {
                builder.setImageURL("/api/images" + this.iconService.getIconPath(target.getIconHash(), type.getName())).setDescription(this.computeDescription(target, type)).setType(new MetaclassQName(type.getName(), type.getMetamodelURI().toString()));
            }
        }
        ModelObjectSummary summary = builder.build();
        this.logger.trace("Summary refreshed: {}", (Object)summary.getId());
        return summary;
    }

    private String computeDescription(IModelObject mo, MetaclassDTO metaclass) {
        String description = "";
        Map jsonProps = mo.getJsonProps();
        if (jsonProps != null) {
            if (this.propertyMappingsDefinition.hasObjectFormMapping(metaclass)) {
                ObjectFormMapping objectFormMapping = (ObjectFormMapping)this.propertyMappingsDefinition.getObjectFormMapping(metaclass).get();
                description = objectFormMapping.descriptionFields().stream().map(fieldName -> jsonProps.getOrDefault(fieldName, "")).map(String::valueOf).collect(Collectors.joining("\n</p>\n<p>\n", "<p>\n", "\n</p>"));
            } else {
                description = mo.getJsonProps().getOrDefault("description", description).toString();
            }
            Pattern pattern = Pattern.compile("hlink://([\\_\\-a-zA-Z0-9]+)");
            Matcher matcher = pattern.matcher(description);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String uid = matcher.group(1);
                matcher.appendReplacement(result, "hlink://" + this.getRepresentationId(uid));
            }
            matcher.appendTail(result);
            description = result.toString();
            description = this.htmlSanitizer.sanitizeHTML(description);
        }
        return description;
    }

    private String getRepresentationId(String uid) {
        Optional optObject = this.modelObjectRepository.findById((Object)new ModelObjectID(this.modelId, uid));
        if (optObject.isPresent()) {
            IModelObject object = (IModelObject)optObject.get();
            MetaclassDTO type = this.mmRegistry.getMetaclassByUid(object.getMetaclassUid()).orElseGet(MetaclassDTO::unknown);
            if (this.mmRegistry.isRepresentation(type)) {
                return this.modelObjectRepository.findById((Object)new ModelObjectID(this.modelId, object.getParentUid())).map(IModelObject::getUid).orElse(uid);
            }
        } else {
            this.logger.warn(String.format("An object with id '%s' is referenced in a description but it cannot be found", uid));
        }
        return uid;
    }

    public Flux<IPayload> getOutputEvents(IInput input) {
        Mono initialRefresh = Mono.fromCallable(() -> new ModelObjectRefreshedEventPayload(input.id(), (ModelObjectSummary)this.currentSummary.get()));
        Flux refreshEventFlux = Flux.concat((Publisher[])new Publisher[]{initialRefresh, this.sink.asFlux()});
        return Flux.merge((Publisher[])new Publisher[]{refreshEventFlux, this.subscriptionManager.getFlux(input)});
    }

    public void dispose() {
        this.subscriptionManager.dispose();
        Sinks.EmitResult emitResult = this.sink.tryEmitComplete();
        if (emitResult.isFailure()) {
            String pattern = "An error has occurred while marking the publisher as complete: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }
}

