/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.FullCommitID;
import fr.obeo.perseus.server.app.processors.ModelSnapshotEventProcessor;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.model.BasicModelID;
import fr.obeo.perseus.server.services.api.model.IModelID;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorFactory;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManagerFactory;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
public class ModelSnapshotEventProcessorFactory
implements IRepresentationEventProcessorFactory {
    private final ISubscriptionManagerFactory subscriptionManagerFactory;
    private final ICommitSearchService commitSearchService;
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final IUriProvider uriProvider;
    private final IIconService iconService;

    public ModelSnapshotEventProcessorFactory(ICommitSearchService commitSearchService, IModelSnapshotSearchService modelSnapshotSearchService, IModelObjectRepository modelObjectRepository, ISubscriptionManagerFactory subscriptionManagerFactory, IUriProvider uriProvider, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IIconService iconService) {
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.subscriptionManagerFactory = Objects.requireNonNull(subscriptionManagerFactory);
        this.uriProvider = Objects.requireNonNull(uriProvider);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.iconService = Objects.requireNonNull(iconService);
    }

    public boolean canHandle(IEditingContext editingContext, String representationId) {
        return editingContext instanceof CommitEditingContext && PerseusRepresentationUtils.isModelRepId((String)representationId);
    }

    public Optional<IRepresentationEventProcessor> createRepresentationEventProcessor(IEditingContext editingContext, String representationId) {
        if (editingContext instanceof CommitEditingContext) {
            CommitEditingContext commitEditingContext = (CommitEditingContext)editingContext;
            FullCommitID fullCommitId = commitEditingContext.getFullCommitId();
            long modelId = PerseusRepresentationUtils.getModelId((String)representationId);
            BasicModelID modelID = new BasicModelID(fullCommitId.projectId(), modelId);
            ModelSnapshotEventProcessor modelEventProcessor = new ModelSnapshotEventProcessor((IModelID)modelID, fullCommitId.commitId(), this.commitSearchService, this.modelSnapshotSearchService, this.subscriptionManagerFactory.create(), this.uriProvider, this.modelAppMessageSourceAccessor, this.iconService);
            return Optional.of(modelEventProcessor);
        }
        return Optional.empty();
    }
}

