/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.eclipse.sirius.components.collaborative.api.ChangeDescription;
import org.eclipse.sirius.components.collaborative.api.IDanglingRepresentationDeletionService;
import org.eclipse.sirius.components.collaborative.api.IEditingContextEventHandler;
import org.eclipse.sirius.components.collaborative.api.IEditingContextEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IInputPostProcessor;
import org.eclipse.sirius.components.collaborative.api.IInputPreProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorComposedFactory;
import org.eclipse.sirius.components.collaborative.dto.DeleteRepresentationInput;
import org.eclipse.sirius.components.collaborative.dto.RepresentationRenamedEventPayload;
import org.eclipse.sirius.components.collaborative.editingcontext.EditingContextEventProcessorParameters;
import org.eclipse.sirius.components.collaborative.editingcontext.RepresentationEventProcessorEntry;
import org.eclipse.sirius.components.collaborative.representations.api.IRepresentationEventProcessorRegistry;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IEditingContextPersistenceService;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.core.api.IRepresentationInput;
import org.eclipse.sirius.components.events.ICause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class PerseusEditingContextEventProcessor
implements IEditingContextEventProcessor {
    public static final String REPRESENTATION_ID = "representationId";
    public static final String REPRESENTATION_LABEL = "representationLabel";
    public static final String INPUT = "INPUT";
    private static final String LOG_TIMING_FORMAT = "%1$6s";
    private final Logger logger = LoggerFactory.getLogger(PerseusEditingContextEventProcessor.class);
    private final IEditingContext editingContext;
    private final IRepresentationEventProcessorRegistry representationEventProcessorRegistry;
    private final IEditingContextPersistenceService editingContextPersistenceService;
    private final List<IEditingContextEventHandler> editingContextEventHandlers;
    private final IRepresentationEventProcessorComposedFactory representationEventProcessorComposedFactory;
    private final IDanglingRepresentationDeletionService danglingRepresentationDeletionService;
    private final Sinks.Many<IPayload> sink = Sinks.many().multicast().directBestEffort();
    private final Sinks.Many<Boolean> canBeDisposedSink = Sinks.many().unicast().onBackpressureBuffer();
    private final Sinks.Many<ChangeDescription> changeDescriptionSink = Sinks.many().unicast().onBackpressureBuffer();
    private final ExecutorService executorService;
    private final Disposable changeDescriptionDisposable;
    private final List<IInputPreProcessor> inputPreProcessors;
    private final List<IInputPostProcessor> inputPostProcessors;
    private final MeterRegistry meterRegistry;

    public PerseusEditingContextEventProcessor(EditingContextEventProcessorParameters parameters) {
        this.editingContext = parameters.editingContext();
        this.representationEventProcessorRegistry = parameters.representationEventProcessorRegistry();
        this.editingContextPersistenceService = parameters.editingContextPersistenceService();
        this.editingContextEventHandlers = parameters.editingContextEventHandlers();
        this.representationEventProcessorComposedFactory = parameters.representationEventProcessorComposedFactory();
        this.danglingRepresentationDeletionService = parameters.danglingRepresentationDeletionService();
        this.executorService = parameters.executorServiceProvider().getExecutorService(this.editingContext);
        this.inputPreProcessors = parameters.inputPreProcessors();
        this.inputPostProcessors = parameters.inputPostProcessors();
        this.changeDescriptionDisposable = this.setupChangeDescriptionSinkConsumer();
        this.meterRegistry = parameters.meterRegistry();
    }

    private Disposable setupChangeDescriptionSinkConsumer() {
        Consumer<ChangeDescription> consumer = changeDescription -> {
            if (changeDescription.getKind().equals("REPRESENTATION_DELETION")) {
                Object representationIdParameter = changeDescription.getParameters().get(REPRESENTATION_ID);
                if (representationIdParameter instanceof String) {
                    String representationId = (String)representationIdParameter;
                    this.disposeRepresentation(representationId);
                }
            } else if ("NOTHING".equals(changeDescription.getKind())) {
                return;
            }
            this.publishEvent(changeDescription);
            this.disposeRepresentationIfNeeded();
            Timer.Sample refreshRepresentationSample = Timer.start((MeterRegistry)this.meterRegistry);
            try {
                RepresentationEventProcessorEntry representationEventProcessorEntry = this.representationEventProcessorRegistry.get(this.editingContext.getId(), changeDescription.getSourceId());
                if (representationEventProcessorEntry != null) {
                    IRepresentationEventProcessor representationEventProcessor = representationEventProcessorEntry.getRepresentationEventProcessor();
                    long start = System.currentTimeMillis();
                    representationEventProcessor.refresh(changeDescription);
                    long end = System.currentTimeMillis();
                    this.logger.atDebug().setMessage("EditingContext {}: {}ms to refresh the {} with id {}").addArgument((Object)this.editingContext.getId()).addArgument(() -> String.format(LOG_TIMING_FORMAT, end - start)).addArgument((Object)representationEventProcessor.getClass().getSimpleName()).addArgument((Object)representationEventProcessor.getRepresentation().getId()).log();
                }
                this.refreshOtherRepresentations(changeDescription);
            }
            catch (Exception exception) {
                this.logger.warn(exception.getMessage(), (Throwable)exception);
            }
            Timer timer = this.meterRegistry.timer("timer_refresh_representation", new String[]{"changeDescription", changeDescription.getSourceId()});
            refreshRepresentationSample.stop(timer);
            if (this.shouldPersistTheEditingContext(changeDescription)) {
                this.editingContextPersistenceService.persist((ICause)changeDescription.getInput(), this.editingContext);
            }
            this.danglingRepresentationDeletionService.deleteDanglingRepresentations((ICause)changeDescription.getInput(), this.editingContext);
        };
        Consumer<Throwable> errorConsumer = throwable -> this.logger.warn(throwable.getMessage(), throwable);
        return this.changeDescriptionSink.asFlux().subscribe(consumer, errorConsumer);
    }

    private void publishEvent(ChangeDescription changeDescription) {
        if (this.sink.currentSubscriberCount() > 0) {
            IInput input = changeDescription.getInput();
            UUID correlationId = input.id();
            if ("REPRESENTATION_RENAMING".equals(changeDescription.getKind()) && !changeDescription.getParameters().isEmpty()) {
                Map parameters = changeDescription.getParameters();
                Optional<String> optionalRepresentationId = Optional.ofNullable(parameters.get(REPRESENTATION_ID)).filter(String.class::isInstance).map(String.class::cast);
                Optional<String> optionalRepresentationLabel = Optional.ofNullable(parameters.get(REPRESENTATION_LABEL)).filter(String.class::isInstance).map(String.class::cast);
                if (optionalRepresentationId.isPresent() && optionalRepresentationLabel.isPresent()) {
                    this.tryEmitRepresentationRenamedEvent(correlationId, optionalRepresentationId.get(), optionalRepresentationLabel.get());
                }
            }
        }
    }

    private void tryEmitRepresentationRenamedEvent(UUID correlationId, String representationId, String newLabel) {
        Sinks.EmitResult emitResult;
        if (this.sink.currentSubscriberCount() > 0 && (emitResult = this.sink.tryEmitNext((Object)new RepresentationRenamedEventPayload(correlationId, representationId, newLabel))).isFailure()) {
            String pattern = "An error has occurred while emitting a RepresentationRenamedEventPayload: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }

    public String getEditingContextId() {
        return this.editingContext.getId();
    }

    public Mono<IPayload> handle(IInput input) {
        Timer.Sample handleTimer = Timer.start((MeterRegistry)this.meterRegistry);
        if (this.executorService.isShutdown()) {
            this.logger.warn("Handler for editing context {} is shutdown", (Object)this.editingContext.getId());
            handleTimer.stop(this.meterRegistry.timer("siriusweb_eventhandlers", new String[]{INPUT, input.getClass().getSimpleName(), "inputId", input.id().toString()}));
            return Mono.empty();
        }
        this.logger.trace(input.toString());
        Sinks.One payloadSink = Sinks.one();
        this.executorService.submit(() -> this.doHandle(payloadSink, input));
        handleTimer.stop(this.meterRegistry.timer("timer_processing_input", new String[]{"input", input.getClass().getSimpleName(), "inputId", input.id().toString()}));
        return payloadSink.asMono().log(this.getClass().getName(), Level.FINEST, new SignalType[]{SignalType.ON_NEXT, SignalType.ON_ERROR}).doOnError(throwable -> this.logger.warn(throwable.getMessage(), throwable));
    }

    private void doHandle(Sinks.One<IPayload> payloadSink, IInput input) {
        this.logger.trace("Input received: {}", (Object)input);
        long start = System.currentTimeMillis();
        AtomicReference<IInput> inputAfterPreProcessing = new AtomicReference<IInput>(input);
        this.inputPreProcessors.forEach(preProcessor -> inputAfterPreProcessing.set(preProcessor.preProcess(this.editingContext, (IInput)inputAfterPreProcessing.get(), this.changeDescriptionSink)));
        IInput iInput = inputAfterPreProcessing.get();
        if (iInput instanceof IRepresentationInput) {
            IRepresentationInput representationInput = (IRepresentationInput)iInput;
            this.handleRepresentationInput(payloadSink, representationInput);
        } else {
            this.handleInput(payloadSink, inputAfterPreProcessing.get());
        }
        this.inputPostProcessors.forEach(postProcessor -> postProcessor.postProcess(this.editingContext, (IInput)inputAfterPreProcessing.get(), this.changeDescriptionSink));
        long end = System.currentTimeMillis();
        this.logger.atDebug().setMessage("EditingContext {}: {}ms to handle the {} with id {}").addArgument((Object)this.editingContext.getId()).addArgument(() -> String.format(LOG_TIMING_FORMAT, end - start)).addArgument((Object)input.getClass().getSimpleName()).addArgument((Object)input.id()).log();
    }

    private void refreshOtherRepresentations(ChangeDescription changeDescription) {
        this.representationEventProcessorRegistry.values(this.editingContext.getId()).stream().filter(representationEventProcessor -> !Objects.equals(changeDescription.getSourceId(), representationEventProcessor.getRepresentation().getId())).forEach(representationEventProcessor -> {
            long start = System.currentTimeMillis();
            representationEventProcessor.refresh(changeDescription);
            long end = System.currentTimeMillis();
            this.logger.atDebug().setMessage("EditingContext {}: {}ms to refresh the {} with id {}").addArgument((Object)this.editingContext.getId()).addArgument(() -> String.format(LOG_TIMING_FORMAT, end - start)).addArgument((Object)representationEventProcessor.getClass().getSimpleName()).addArgument((Object)representationEventProcessor.getRepresentation().getId()).log();
        });
    }

    private boolean shouldPersistTheEditingContext(ChangeDescription changeDescription) {
        return "SEMANTIC_CHANGE".equals(changeDescription.getKind());
    }

    private void disposeRepresentationIfNeeded() {
        for (IRepresentationEventProcessor representationEventProcessor : this.representationEventProcessorRegistry.values(this.editingContext.getId())) {
            if (!this.danglingRepresentationDeletionService.isDangling(this.editingContext, representationEventProcessor.getRepresentation())) continue;
            this.disposeRepresentation(representationEventProcessor.getRepresentation().getId());
        }
    }

    private void handleInput(Sinks.One<IPayload> payloadSink, IInput input) {
        Optional<IEditingContextEventHandler> optionalEditingContextEventHandler;
        if (input instanceof DeleteRepresentationInput) {
            DeleteRepresentationInput deleteRepresentationInput = (DeleteRepresentationInput)input;
            this.disposeRepresentation(deleteRepresentationInput.representationId());
        }
        if ((optionalEditingContextEventHandler = this.editingContextEventHandlers.stream().filter(handler -> handler.canHandle(this.editingContext, input)).findFirst()).isPresent()) {
            IEditingContextEventHandler editingContextEventHandler = optionalEditingContextEventHandler.get();
            editingContextEventHandler.handle(payloadSink, this.changeDescriptionSink, this.editingContext, input);
        } else {
            this.logger.warn("No handler found for event: {}", (Object)input);
        }
    }

    private void handleRepresentationInput(Sinks.One<IPayload> payloadSink, IRepresentationInput representationInput) {
        Optional optionalRepresentationEventProcessor = this.acquireRepresentationEventProcessor(representationInput.representationId(), (IInput)representationInput);
        if (optionalRepresentationEventProcessor.isPresent()) {
            IRepresentationEventProcessor representationEventProcessor = (IRepresentationEventProcessor)optionalRepresentationEventProcessor.get();
            representationEventProcessor.handle(payloadSink, this.changeDescriptionSink, representationInput);
        } else {
            this.logger.warn("No representation event processor found for event: {}", (Object)representationInput);
        }
    }

    public Optional<IRepresentationEventProcessor> acquireRepresentationEventProcessor(String representationId, IInput input) {
        Timer.Sample getRepresentationEventProcessorSample = Timer.start((MeterRegistry)this.meterRegistry);
        Optional optionalRepresentationEventProcessor = Optional.ofNullable(this.representationEventProcessorRegistry.get(this.editingContext.getId(), representationId)).map(RepresentationEventProcessorEntry::getRepresentationEventProcessor);
        if (optionalRepresentationEventProcessor.isEmpty()) {
            optionalRepresentationEventProcessor = this.representationEventProcessorComposedFactory.createRepresentationEventProcessor(this.editingContext, representationId);
            if (optionalRepresentationEventProcessor.isPresent()) {
                IRepresentationEventProcessor representationEventProcessor = (IRepresentationEventProcessor)optionalRepresentationEventProcessor.get();
                Disposable subscription = representationEventProcessor.canBeDisposed().delayElements(Duration.ofSeconds(5L)).publishOn(Schedulers.fromExecutorService((ExecutorService)this.executorService)).subscribe(canBeDisposed -> {
                    if (canBeDisposed.booleanValue() && representationEventProcessor.getSubscriptionManager().isEmpty()) {
                        this.disposeRepresentation(representationId);
                    } else {
                        this.logger.trace("Stopping the disposal of the representation event processor {}", (Object)representationId);
                    }
                }, throwable -> this.logger.warn(throwable.getMessage(), throwable));
                RepresentationEventProcessorEntry representationEventProcessorEntry = new RepresentationEventProcessorEntry(representationEventProcessor, subscription);
                this.representationEventProcessorRegistry.put(this.editingContext.getId(), representationId, representationEventProcessorEntry);
            } else {
                this.logger.debug("The representation with the id {} does not exist", (Object)representationId);
            }
        } else {
            Timer timer = this.meterRegistry.timer("timer_create_representation_event_processor", new String[]{"editingContext", this.editingContext.getId(), "input", input.getClass().getSimpleName(), REPRESENTATION_ID, representationId});
            getRepresentationEventProcessorSample.stop(timer);
        }
        this.logger.trace("Representation event processors count: {}", (Object)this.representationEventProcessorRegistry.values(this.editingContext.getId()).size());
        return optionalRepresentationEventProcessor;
    }

    public List<IRepresentationEventProcessor> getRepresentationEventProcessors() {
        return this.representationEventProcessorRegistry.values(this.editingContext.getId());
    }

    private void disposeRepresentation(String representationId) {
        Sinks.EmitResult emitResult;
        this.representationEventProcessorRegistry.disposeRepresentation(this.editingContext.getId(), representationId);
        if (this.representationEventProcessorRegistry.values(this.editingContext.getId()).isEmpty() && (emitResult = this.canBeDisposedSink.tryEmitNext((Object)Boolean.TRUE)).isFailure()) {
            String pattern = "An error has occurred while emitting that the processor can be disposed: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }

    public Flux<IPayload> getOutputEvents() {
        return this.sink.asFlux();
    }

    public Flux<Boolean> canBeDisposed() {
        return this.canBeDisposedSink.asFlux();
    }

    public void dispose() {
        this.logger.trace("Disposing the editing context event processor {}", (Object)this.editingContext.getId());
        Sinks.EmitResult changeDescriptionEmitResult = this.changeDescriptionSink.tryEmitComplete();
        if (changeDescriptionEmitResult.isFailure()) {
            String pattern = "An error has occurred while marking the publisher as complete: {}";
            this.logger.warn(pattern, (Object)changeDescriptionEmitResult);
        }
        this.changeDescriptionDisposable.dispose();
        this.executorService.shutdown();
        this.representationEventProcessorRegistry.dispose(this.editingContext.getId());
        this.editingContext.dispose();
        Sinks.EmitResult emitResult = this.sink.tryEmitComplete();
        if (emitResult.isFailure()) {
            String pattern = "An error has occurred while marking the publisher as complete: {}";
            this.logger.warn(pattern, (Object)emitResult);
        }
    }
}

