/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.processors;

import fr.obeo.perseus.server.app.processors.PerseusProjectEventProcessor;
import fr.obeo.perseus.server.services.api.IModelService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorFactory;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManagerFactory;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.web.application.project.services.api.IProjectEditingContextService;
import org.springframework.stereotype.Service;

@Service
public class PerseusProjectEventProcessorFactory
implements IRepresentationEventProcessorFactory {
    private final ISubscriptionManagerFactory subscriptionManagerFactory;
    private final IModelService modelService;
    private final IProjectEditingContextService projectEditingContextService;

    public PerseusProjectEventProcessorFactory(ISubscriptionManagerFactory subscriptionManagerFactory, IModelService modelService, IProjectEditingContextService projectEditingContextService) {
        this.subscriptionManagerFactory = Objects.requireNonNull(subscriptionManagerFactory);
        this.modelService = Objects.requireNonNull(modelService);
        this.projectEditingContextService = Objects.requireNonNull(projectEditingContextService);
    }

    public boolean canHandle(IEditingContext editingContext, String representationId) {
        try {
            UUID.fromString(representationId);
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        return true;
    }

    public Optional<IRepresentationEventProcessor> createRepresentationEventProcessor(IEditingContext editingContext, String representationId) {
        PerseusProjectEventProcessor eventProcessor = new PerseusProjectEventProcessor(representationId, this.subscriptionManagerFactory.create(), this.modelService, this.projectEditingContextService);
        return Optional.of(eventProcessor);
    }
}

