/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.properties;

import fr.obeo.perseus.server.app.properties.ModelObjectGroupDescriptionProvider;
import fr.obeo.perseus.server.common.LabelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.sirius.components.collaborative.forms.api.IPropertiesDefaultDescriptionProvider;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.core.api.ILabelService;
import org.eclipse.sirius.components.core.api.labels.StyledString;
import org.eclipse.sirius.components.forms.description.FormDescription;
import org.eclipse.sirius.components.forms.description.GroupDescription;
import org.eclipse.sirius.components.forms.description.PageDescription;
import org.eclipse.sirius.components.representations.GetOrCreateRandomIdProvider;
import org.eclipse.sirius.components.representations.VariableManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
@Primary
public class PerseusPropertiesDefaultDescriptionProvider
implements IPropertiesDefaultDescriptionProvider {
    private final IIdentityService identityService;
    private final ILabelService labelService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final ModelObjectGroupDescriptionProvider modelObjectGroupDescriptionProvider;

    public PerseusPropertiesDefaultDescriptionProvider(IIdentityService identityService, ILabelService labelService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, ModelObjectGroupDescriptionProvider modelObjectGroupDescriptionProvider) {
        this.identityService = Objects.requireNonNull(identityService);
        this.labelService = Objects.requireNonNull(labelService);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.modelObjectGroupDescriptionProvider = Objects.requireNonNull(modelObjectGroupDescriptionProvider);
    }

    public FormDescription getFormDescription() {
        ArrayList<GroupDescription> groupDescriptions = new ArrayList<GroupDescription>();
        groupDescriptions.add(this.modelObjectGroupDescriptionProvider.getModelObjectGroupDescription());
        ArrayList<PageDescription> pageDescriptions = new ArrayList<PageDescription>();
        PageDescription firstPageDescription = this.getPageDescription(groupDescriptions);
        pageDescriptions.add(firstPageDescription);
        Function<VariableManager, String> labelProvider = variableManager -> Optional.ofNullable(variableManager.getVariables().get("self")).filter(self -> self instanceof List).map(self -> (List)self).flatMap(self -> self.stream().findFirst()).map(arg_0 -> ((ILabelService)this.labelService).getStyledLabel(arg_0)).map(StyledString::toString).orElseGet(() -> this.modelAppMessageSourceAccessor.getMessage("props.form.label"));
        return FormDescription.newFormDescription((String)"perseus_form_description").label("Perseus Form Description").idProvider((Function)new GetOrCreateRandomIdProvider()).labelProvider(labelProvider).targetObjectIdProvider(variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElse(null)).canCreatePredicate(variableManager -> false).pageDescriptions(pageDescriptions).iconURLsProvider(variableManager -> List.of()).build();
    }

    private PageDescription getPageDescription(List<GroupDescription> groupDescriptions) {
        Function<VariableManager, String> idProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElseGet(() -> UUID.randomUUID().toString());
        Function<VariableManager, String> labelProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((ILabelService)this.labelService).getStyledLabel(arg_0)).map(StyledString::toString).map(LabelUtil::getTruncatedLabel).orElseGet(() -> this.modelAppMessageSourceAccessor.getMessage("props.page.label"));
        return PageDescription.newPageDescription((String)"firstPageId").idProvider(idProvider).labelProvider(labelProvider).semanticElementsProvider(variableManager -> Collections.singletonList(variableManager.getVariables().get("self"))).groupDescriptions(groupDescriptions).canCreatePredicate(variableManager -> true).build();
    }
}

