/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.FullCommitID;
import fr.obeo.perseus.server.app.services.ICommitEditingContextService;
import fr.obeo.perseus.server.versioning.ICommit;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CommitEditingContextService
implements ICommitEditingContextService {
    private final ICommitSearchService commitSearchService;

    public CommitEditingContextService(ICommitSearchService commitSearchService) {
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
    }

    public Optional<String> getEditingContextId(FullCommitID fullCommitId) {
        return this.commitSearchService.findCommit(fullCommitId.projectId(), fullCommitId.commitId()).map(commit -> CommitEditingContext.toParsableString((FullCommitID)fullCommitId));
    }

    public Optional<ICommit> getCommit(String editingContextId) {
        return CommitEditingContext.parseCommitId((String)editingContextId).flatMap(fullCommitId -> this.commitSearchService.findCommit(fullCommitId.projectId(), fullCommitId.commitId()));
    }
}

