/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.services.IEditingContextAwareRepresentationMetadataProvider;
import fr.obeo.perseus.server.common.LabelUtil;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.sirius.components.core.RepresentationMetadata;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.ILabelService;
import org.eclipse.sirius.components.core.api.IObjectSearchService;
import org.eclipse.sirius.components.core.api.labels.StyledString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelRepresentationMetadataProvider
implements IEditingContextAwareRepresentationMetadataProvider {
    private static final String MODEL_REP_KIND = "siriusComponents://representation?type=Model";
    @Autowired
    private IObjectSearchService objectSearchService;
    @Autowired
    private ILabelService labelService;

    public Optional<RepresentationMetadata> getMetadata(IEditingContext editingContext, String representationId) {
        if (PerseusRepresentationUtils.isModelRepId((String)representationId)) {
            return this.objectSearchService.getObject(editingContext, representationId).map(arg_0 -> ((ILabelService)this.labelService).getStyledLabel(arg_0)).map(StyledString::toString).map(LabelUtil::getTruncatedLabel).map(label -> this.createMetadata(representationId, label));
        }
        return Optional.empty();
    }

    private RepresentationMetadata createMetadata(String representationId, String label) {
        return new RepresentationMetadata(representationId, MODEL_REP_KIND, label, "model_description", Collections.emptyList());
    }
}

