/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.IExtConfiguration;
import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.common.LabelUtil;
import fr.obeo.perseus.server.dto.model.ModelDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.oslc.globalconf.api.IGlobalConfService;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.api.IModelService;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.model.RepresentationInModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.model.RepresentationTypeNode;
import fr.obeo.perseus.server.services.api.dto.versioning.MetaclassQNameFilter;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshot;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshotNode;
import fr.obeo.perseus.server.services.api.model.BasicModelID;
import fr.obeo.perseus.server.services.api.model.IModelID;
import fr.obeo.perseus.server.services.api.model.versioning.IModelHistorySearchService;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.usersettings.services.api.IMetaclassFilter;
import fr.obeo.perseus.server.util.MetaclassPredicates;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.ICommit;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.sirius.components.core.api.IContentService;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IEditingContextRepresentationDescriptionProvider;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.core.api.ILabelService;
import org.eclipse.sirius.components.core.api.labels.StyledString;
import org.eclipse.sirius.components.representations.Failure;
import org.eclipse.sirius.components.representations.GetOrCreateRandomIdProvider;
import org.eclipse.sirius.components.representations.IRepresentationDescription;
import org.eclipse.sirius.components.representations.VariableManager;
import org.eclipse.sirius.components.trees.description.TreeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
public class PerseusExplorerDescriptionProvider
implements IEditingContextRepresentationDescriptionProvider {
    public static final String DESCRIPTION_ID = "perseus_explorer_tree_description";
    private static final Logger LOGGER = LoggerFactory.getLogger(PerseusExplorerDescriptionProvider.class);
    private final IIdentityService identityService;
    private final ILabelService labelService;
    private final IContentService contentService;
    private final IModelService modelService;
    private final IModelObjectRepository modelObjectRepo;
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final ICommitSearchService commitSearchService;
    private final IModelHistorySearchService modelHistorySearchService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final Supplier<IMetaclassFilter> metaclassFilterSupplier;
    private final Supplier<MetaclassQNameFilter> metaclassQNameFilterSupplier;
    private final IGlobalConfService globalConfService;

    public PerseusExplorerDescriptionProvider(IIdentityService identityService, ILabelService labelService, IContentService contentService, IModelService modelService, IModelObjectRepository modelObjectRepo, IModelSnapshotSearchService modelSnapshotSearchService, ICommitSearchService commitSearchService, IModelHistorySearchService modelHistorySearchService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, Supplier<IMetaclassFilter> metaclassFilterSupplier, Supplier<MetaclassQNameFilter> metaclassQNameFilterSupplier, IGlobalConfService globalConfService) {
        this.identityService = Objects.requireNonNull(identityService);
        this.labelService = Objects.requireNonNull(labelService);
        this.contentService = Objects.requireNonNull(contentService);
        this.modelService = Objects.requireNonNull(modelService);
        this.modelObjectRepo = Objects.requireNonNull(modelObjectRepo);
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.modelHistorySearchService = Objects.requireNonNull(modelHistorySearchService);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.metaclassFilterSupplier = Objects.requireNonNull(metaclassFilterSupplier);
        this.metaclassQNameFilterSupplier = Objects.requireNonNull(metaclassQNameFilterSupplier);
        this.globalConfService = Objects.requireNonNull(globalConfService);
    }

    public TreeDescription getExplorerDescription(IEditingContext editingContext) {
        Predicate<VariableManager> canCreatePredicate = variableManager -> variableManager.get("treeDescriptionId", String.class).map(treeId -> treeId.startsWith("explorer://")).orElse(false);
        return TreeDescription.newTreeDescription((String)DESCRIPTION_ID).label(this.modelAppMessageSourceAccessor.getMessage("explorer.view.label")).idProvider((Function)new GetOrCreateRandomIdProvider()).treeItemIdProvider(arg_0 -> this.getTreeItemId(arg_0)).kindProvider(arg_0 -> this.getKind(arg_0)).labelProvider(arg_0 -> this.getLabel(arg_0)).targetObjectIdProvider(variableManager -> variableManager.get("editingContext", IEditingContext.class).map(IEditingContext::getId).orElse(null)).parentObjectProvider(variableManager -> null).treeItemIconURLsProvider(arg_0 -> this.getIconURL(arg_0)).editableProvider(variableManager -> false).deletableProvider(variableManager -> false).selectableProvider(arg_0 -> this.isSelectable(arg_0)).elementsProvider(arg_0 -> this.getElements(arg_0)).hasChildrenProvider(arg_0 -> this.hasChildren(arg_0)).childrenProvider(arg_0 -> this.getChildren(arg_0)).canCreatePredicate(canCreatePredicate).deleteHandler(variableManager -> new Failure("")).renameHandler((variableManager, newLabel) -> new Failure("")).treeItemObjectProvider(variableManager -> null).treeItemLabelProvider(arg_0 -> this.getLabel(arg_0)).iconURLsProvider(variableManager -> List.of()).build();
    }

    private String getTreeItemId(VariableManager variableManager) {
        Object self = variableManager.getVariables().get("self");
        return this.identityService.getId(self);
    }

    private String getKind(VariableManager variableManager) {
        Object self = variableManager.getVariables().get("self");
        return this.identityService.getKind(self);
    }

    private StyledString getLabel(VariableManager variableManager) {
        ModelDTO model;
        Optional optConfig;
        Object self = variableManager.getVariables().get("self");
        Object label = LabelUtil.getTruncatedLabel((String)this.labelService.getStyledLabel(self).toString());
        if (self instanceof ModelDTO && (optConfig = this.globalConfService.getModelAssignedGlobalConf((model = (ModelDTO)self).getId())).isPresent()) {
            label = (String)label + String.format(" [%s]", ((IExtConfiguration)optConfig.get()).getTitle());
        }
        return StyledString.of((String)label);
    }

    private boolean isSelectable(VariableManager variableManager) {
        Object self = variableManager.getVariables().get("self");
        return !(self instanceof RepresentationTypeNode);
    }

    private List<String> getIconURL(VariableManager variableManager) {
        Object self = variableManager.getVariables().get("self");
        return this.labelService.getImagePaths(self);
    }

    private List<? extends Object> getElements(VariableManager variableManager) {
        Optional optionalEditingContext = Optional.of(variableManager.getVariables().get("editingContext"));
        List result = optionalEditingContext.map(editingContext -> {
            if (editingContext instanceof ProjectEditingContext) {
                ProjectEditingContext pec = (ProjectEditingContext)editingContext;
                List result2 = this.modelService.getModels(pec.getProjectId(), false);
                result2.sort((m1, m2) -> String.valueOf(m1.getName()).compareTo(String.valueOf(m2.getName())));
                return result2;
            }
            if (editingContext instanceof CommitEditingContext) {
                CommitEditingContext cec = (CommitEditingContext)editingContext;
                return this.modelHistorySearchService.findModelHistoryByBranchId(cec.getFullCommitId().commitId().getBranchId()).flatMap(modelHistory -> {
                    String projectId = cec.getFullCommitId().projectId();
                    CommitID commitId = cec.getFullCommitId().commitId();
                    BasicModelID modelId = new BasicModelID(projectId, modelHistory.getModelId());
                    return this.commitSearchService.findCommit(projectId, commitId).flatMap(arg_0 -> this.lambda$getElements$11((IModelID)modelId, arg_0)).map(arg_0 -> PerseusExplorerDescriptionProvider.lambda$getElements$12((IModelID)modelId, commitId, arg_0)).map(List::of);
                }).orElseGet(List::of);
            }
            return List.of();
        }).orElseGet(List::of);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasChildren(VariableManager variableManager) {
        Object self = variableManager.getVariables().get("self");
        Object editingContext = variableManager.getVariables().get("editingContext");
        boolean hasChildren = false;
        IMetaclassFilter filter = (IMetaclassFilter)this.metaclassFilterSupplier.get();
        if (editingContext instanceof ProjectEditingContext) {
            if (self instanceof ModelDTO) {
                return this.modelService.getRoots(((ModelDTO)self).getId()).anyMatch(MetaclassPredicates.treeNodePredicate((IMetaclassFilter)filter));
            }
            if (self instanceof RepresentationTypeNode) {
                return true;
            }
            if (self instanceof RepresentationInModelObjectNode) {
                return false;
            }
            if (!(self instanceof ModelObjectNode)) return hasChildren;
            ModelObjectNode node = (ModelObjectNode)self;
            Predicate idPredicate = MetaclassPredicates.idPredicate((IMetaclassFilter)filter);
            hasChildren = node.getChildrenTypes().stream().anyMatch(idPredicate);
            if (hasChildren) return true;
            if (!this.modelObjectRepo.getRepresentationsOwnedBy(new ModelObjectID(node.getModelId(), node.getId())).stream().map(mo -> mo.getMetaclassUid()).anyMatch(idPredicate)) return false;
            return true;
        }
        if (!(editingContext instanceof CommitEditingContext)) return hasChildren;
        if (self instanceof ModelObjectSnapshotNode) {
            ModelObjectSnapshotNode mosn = (ModelObjectSnapshotNode)self;
            MetaclassQNameFilter qNameFilter = (MetaclassQNameFilter)this.metaclassQNameFilterSupplier.get();
            MetaclassQName mcQName = mosn.snapshot().getIntrinsic().getMetaclass();
            if (!mcQName.isView()) return Optional.ofNullable(mosn.snapshot().getIntrinsic().getTypedChildrenRefs()).filter(refs -> refs.stream().anyMatch(ref -> qNameFilter.test(ref.metaclassQName()))).isPresent();
            if (!qNameFilter.test(new MetaclassQName("RepresentationDescriptor", "http://www.obeo.fr/perseus/server/representations/1.1"))) return false;
            if (Optional.ofNullable(mosn.snapshot().getIntrinsic().getStructuralFeatureSettings().get("ownedRepresentationDescriptors")).map(List.class::cast).map(l -> !l.isEmpty()).orElse(false) == false) return false;
            return true;
        }
        if (self instanceof ModelSnapshotNode) {
            ModelSnapshotNode ims = (ModelSnapshotNode)self;
            return Optional.ofNullable(ims.snapshot().derived()).map(derived -> !derived.roots().isEmpty()).orElse(false);
        }
        if (self instanceof RepresentationTypeNode) {
            return true;
        }
        if (!(self instanceof RepresentationInModelObjectNode)) return hasChildren;
        return false;
    }

    private List<Object> getChildren(VariableManager variableManager) {
        String id;
        Object editingContext;
        long start = System.nanoTime();
        ArrayList<Object> result = new ArrayList<Object>();
        List<Object> expandedIds = new ArrayList();
        Object objects = variableManager.getVariables().get("expanded");
        if (objects instanceof List) {
            expandedIds = ((List)objects).stream().filter(String.class::isInstance).map(String.class::cast).toList();
        }
        if ((editingContext = variableManager.getVariables().get("editingContext")) instanceof IEditingContext && expandedIds.contains(id = this.getTreeItemId(variableManager))) {
            Object self = variableManager.getVariables().get("self");
            result.addAll(this.contentService.getContents(self));
        }
        if (LOGGER.isDebugEnabled()) {
            long end = System.nanoTime();
            LOGGER.debug("getChildren took {} ns for {} children", (Object)(end - start), (Object)result.size());
        }
        return result;
    }

    public List<IRepresentationDescription> getRepresentationDescriptions(IEditingContext editingContext) {
        return List.of(this.getExplorerDescription(editingContext));
    }

    private static /* synthetic */ ModelSnapshotNode lambda$getElements$12(IModelID modelId, CommitID commitId, ModelSnapshot modelSnapshot) {
        return new ModelSnapshotNode(modelId, commitId, modelSnapshot);
    }

    private /* synthetic */ Optional lambda$getElements$11(IModelID modelId, ICommit commit) {
        return this.modelSnapshotSearchService.findModelSnapshot(modelId, commit);
    }
}

