/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.meta.services.api.IMetaclassRegistry;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.model.RepresentationTypeNode;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.collaborative.trees.api.ITreePathProvider;
import org.eclipse.sirius.components.collaborative.trees.dto.TreePath;
import org.eclipse.sirius.components.collaborative.trees.dto.TreePathInput;
import org.eclipse.sirius.components.collaborative.trees.dto.TreePathSuccessPayload;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.core.api.IObjectSearchService;
import org.eclipse.sirius.components.trees.Tree;
import org.springframework.stereotype.Service;

@Service
public class PerseusExplorerTreePathProvider
implements ITreePathProvider {
    private final IObjectSearchService objectSearchService;
    private final IMetaclassRegistry mcRegistry;
    private final IModelObjectRepository modelObjectRepo;
    private final IIdentityService identityService;

    public PerseusExplorerTreePathProvider(IObjectSearchService objectSearchService, IMetaclassRegistry mcRegistry, IModelObjectRepository modelObjectRepo, IIdentityService identityService) {
        this.objectSearchService = Objects.requireNonNull(objectSearchService);
        this.mcRegistry = Objects.requireNonNull(mcRegistry);
        this.modelObjectRepo = Objects.requireNonNull(modelObjectRepo);
        this.identityService = Objects.requireNonNull(identityService);
    }

    public boolean canHandle(Tree tree) {
        return tree != null && Objects.equals("perseus_explorer_tree_description", tree.getDescriptionId());
    }

    public TreePathSuccessPayload handle(IEditingContext editingContext, Tree tree, TreePathInput input) {
        int maxDepth = 0;
        HashSet allAncestors = new HashSet();
        for (String itemId : input.selectionEntryIds()) {
            List itemAncestors = this.getAncestors(editingContext, itemId);
            allAncestors.addAll(itemAncestors);
            maxDepth = Math.max(maxDepth, itemAncestors.size());
        }
        return new TreePathSuccessPayload(input.id(), new TreePath(allAncestors.stream().toList(), maxDepth));
    }

    private List<String> getAncestors(IEditingContext editingContext, String itemToReveal) {
        ArrayList<String> ancestorsIds = new ArrayList<String>();
        String perseusObjectId = URLDecoder.decode(itemToReveal, StandardCharsets.UTF_8);
        Optional optionalObject = this.objectSearchService.getObject(editingContext, perseusObjectId).flatMap(perseusObject -> this.getParent(editingContext, perseusObject));
        while (optionalObject.isPresent()) {
            ancestorsIds.add(this.getItemId(optionalObject.get()));
            optionalObject = this.getParent(editingContext, optionalObject.get());
        }
        return ancestorsIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<Object> getParent(IEditingContext editingContext, Object object) {
        Optional result = Optional.empty();
        if (object instanceof ModelObjectNode) {
            ModelObjectNode node = (ModelObjectNode)object;
            if (this.mcRegistry.getMetaclassByUid(node.getMetaclassId()).map(arg_0 -> ((IMetaclassRegistry)this.mcRegistry).isRepresentationDescriptor(arg_0)).orElse(false).booleanValue()) {
                return this.getRepresentationType(node).map(representationType -> new RepresentationTypeNode(new ModelObjectID(node.getModelId(), node.getParentId()), representationType, Collections.emptyList()));
            }
            if (node.getParentId() == null) return Optional.of(PerseusRepresentationUtils.toModelRepId((long)node.getModelId()));
            return this.objectSearchService.getObject(editingContext, PerseusRepresentationUtils.toModelObjectRepId((long)node.getModelId(), (String)node.getParentId()));
        }
        if (object instanceof ModelObjectSnapshotNode) {
            ModelObjectSnapshotNode imos = (ModelObjectSnapshotNode)object;
            if (editingContext instanceof CommitEditingContext) {
                CommitEditingContext cec = (CommitEditingContext)editingContext;
                Optional optParentId = Optional.ofNullable(imos.snapshot().getDerived()).flatMap(DerivedModelObjectData::getParentId);
                if (!optParentId.isPresent()) return Optional.of(cec.getModel());
                return optParentId.flatMap(parentId -> {
                    if (imos.snapshot().getIntrinsic().getMetaclass().isRepresentationDescriptor()) {
                        return Optional.ofNullable(imos.snapshot().getIntrinsic().getStructuralFeatureSettings().get("representationType")).filter(String.class::isInstance).map(representationType -> new RepresentationTypeNode(new ModelObjectID(imos.model().id().getModelId(), parentId), (String)representationType, Collections.emptyList()));
                    }
                    return this.objectSearchService.getObject(editingContext, PerseusRepresentationUtils.toModelObjectRepId((long)imos.model().id().getModelId(), (String)parentId));
                });
            }
        }
        if (!(object instanceof RepresentationTypeNode)) return result;
        RepresentationTypeNode rtn = (RepresentationTypeNode)object;
        return this.objectSearchService.getObject(editingContext, PerseusRepresentationUtils.toModelObjectRepId((long)rtn.getModelId(), (String)rtn.getParentId()));
    }

    private Optional<String> getRepresentationType(ModelObjectNode node) {
        return this.modelObjectRepo.findById((Object)new ModelObjectID(node.getModelId(), node.getId())).map(row -> {
            Map jsonProps = row.getJsonProps();
            if (jsonProps != null) {
                try {
                    return String.valueOf(jsonProps.get("representationType"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    private String getItemId(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return this.identityService.getId(object);
    }
}

