/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.services.IEditingContextAwareRepresentationMetadataSearchService;
import fr.obeo.perseus.server.common.LabelUtil;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.ILabelService;
import org.eclipse.sirius.components.core.api.IObjectSearchService;
import org.eclipse.sirius.components.core.api.labels.StyledString;
import org.eclipse.sirius.components.core.graphql.dto.RepresentationMetadataDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PerseusRepresentationMetadataSearchService
implements IEditingContextAwareRepresentationMetadataSearchService {
    private static final String MODEL_OBJECT_REP_KIND = "siriusComponents://representation?type=ModelObject";
    private static final String MODEL_REP_KIND = "siriusComponents://representation?type=Model";
    @Autowired
    private IObjectSearchService objectSearchService;
    @Autowired
    private ILabelService labelService;

    @Transactional(readOnly=true)
    public Optional<RepresentationMetadataDTO> findRepresentationMetadataById(IEditingContext editingContext, String representationMetadataId) {
        Optional<RepresentationMetadataDTO> result = PerseusRepresentationUtils.isModelObjectRepId((String)representationMetadataId) ? this.objectSearchService.getObject(editingContext, representationMetadataId).map(arg_0 -> ((ILabelService)this.labelService).getStyledLabel(arg_0)).map(StyledString::toString).map(LabelUtil::getTruncatedLabel).map(label -> this.createModelObjectMetadata(representationMetadataId, label)) : (PerseusRepresentationUtils.isModelRepId((String)representationMetadataId) ? this.objectSearchService.getObject(editingContext, representationMetadataId).map(arg_0 -> ((ILabelService)this.labelService).getStyledLabel(arg_0)).map(StyledString::toString).map(LabelUtil::getTruncatedLabel).map(label -> this.createModelMetadata(representationMetadataId, label)) : Optional.empty());
        return result;
    }

    private RepresentationMetadataDTO createModelObjectMetadata(String representationId, String label) {
        return new RepresentationMetadataDTO(representationId, label, MODEL_OBJECT_REP_KIND, "model_object_description", Collections.emptyList());
    }

    private RepresentationMetadataDTO createModelMetadata(String representationId, String label) {
        return new RepresentationMetadataDTO(representationId, label, MODEL_REP_KIND, "model_description", Collections.emptyList());
    }
}

