/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.common.representations.PerseusRepresentationUtils;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshotNode;
import fr.obeo.perseus.server.services.api.model.BasicModelID;
import fr.obeo.perseus.server.services.api.model.IModelID;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.model.versioning.IModelSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.BasicModelObjectID;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IObjectSearchServiceDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PerseusSnapshotSearchServiceDelegate
implements IObjectSearchServiceDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(PerseusSnapshotSearchServiceDelegate.class);
    private final IModelSnapshotSearchService modelSnapshotSearchService;
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;

    public PerseusSnapshotSearchServiceDelegate(IModelSnapshotSearchService modelSnapshotSearchService, IModelObjectSnapshotSearchService modelObjectSnapshotSearchService) {
        this.modelSnapshotSearchService = Objects.requireNonNull(modelSnapshotSearchService);
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
    }

    /*
     * Unable to fully structure code
     */
    public boolean canHandle(IEditingContext editingContext, String objectId) {
        if (!(editingContext instanceof CommitEditingContext)) ** GOTO lbl-1000
        cec = (CommitEditingContext)editingContext;
        if (PerseusRepresentationUtils.isModelObjectRepId((String)objectId) || PerseusRepresentationUtils.isModelRepId((String)objectId) || cec.getFullCommitId().projectId().equals(objectId)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = result = false;
        }
        if (PerseusSnapshotSearchServiceDelegate.LOG.isDebugEnabled()) {
            PerseusSnapshotSearchServiceDelegate.LOG.debug(String.format("%s - can handle object '%s' in editing context %s: %b", new Object[]{this.getClass().getSimpleName(), objectId, editingContext, result}));
        }
        return result;
    }

    public Optional<Object> getObject(IEditingContext editingContext, String objectId) {
        Optional<Object> result = Optional.empty();
        if (editingContext instanceof CommitEditingContext) {
            CommitEditingContext cec = (CommitEditingContext)editingContext;
            String projectId = cec.getFullCommitId().projectId();
            if (projectId.equals(objectId)) {
                result = Optional.of(objectId);
            } else if (PerseusRepresentationUtils.isModelObjectRepId((String)objectId)) {
                long modelID = PerseusRepresentationUtils.getModelId((String)objectId);
                String modelObjectID = PerseusRepresentationUtils.getModelObjectId((String)objectId);
                BasicModelObjectID id = new BasicModelObjectID(projectId, modelID, modelObjectID);
                result = this.modelObjectSnapshotSearchService.findModelObjectInCommit((IModelObjectID)id, cec.getCommit()).map(snapshot -> new ModelObjectSnapshotNode(cec.getModel(), modelObjectID, snapshot));
            } else if (PerseusRepresentationUtils.isModelRepId((String)objectId)) {
                long modelID = PerseusRepresentationUtils.getModelId((String)objectId);
                BasicModelID id = new BasicModelID(projectId, modelID);
                result = this.modelSnapshotSearchService.findModelSnapshot((IModelID)id, cec.getCommit()).map(snapshot -> new ModelSnapshotNode((IModelID)id, cec.getCommit().getId(), snapshot));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%s - getObject '%s' in editing context %s returns: %s", this.getClass().getSimpleName(), objectId, editingContext, result));
        }
        return result;
    }
}

