/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services;

import fr.obeo.ocp.domain.boundedcontexts.account.Account;
import fr.obeo.ocp.domain.boundedcontexts.account.PasswordCredentials;
import fr.obeo.ocp.domain.boundedcontexts.authorization.services.api.IRoleSearchService;
import fr.obeo.ocp.infrastructure.security.OCPUser;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PerseusUsernamePasswordUserService
implements UserDetailsService {
    private final JdbcClient jdbcClient;
    private final RelationalMappingContext relationalMappingContext;
    private final JdbcConverter jdbcConverter;
    private final IRoleSearchService roleSearchService;

    public PerseusUsernamePasswordUserService(IRoleSearchService roleSearchService, JdbcClient jdbcClient, RelationalMappingContext context, JdbcConverter converter) {
        this.roleSearchService = Objects.requireNonNull(roleSearchService);
        this.jdbcClient = Objects.requireNonNull(jdbcClient);
        this.relationalMappingContext = Objects.requireNonNull(context);
        this.jdbcConverter = Objects.requireNonNull(converter);
    }

    @Transactional(readOnly=true)
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.executeQuery("SELECT * FROM account WHERE name = :username OR username = :username", Map.of("username", username)).map(arg_0 -> this.toUserDetails(arg_0)).orElseThrow(() -> new UsernameNotFoundException(MessageFormat.format("User ''{0}'' not found", username)));
    }

    private UserDetails toUserDetails(Account account) {
        List authorities = this.roleSearchService.findById((UUID)account.getRole().getId()).map(role -> List.of(new SimpleGrantedAuthority("ROLE_" + role.getName()))).orElseGet(List::of);
        User user = new User(account.getUsername(), this.getPassword(account), account.isEnabled(), true, true, true, (Collection)authorities);
        return new OCPUser(account.getId(), user);
    }

    private String getPassword(Account account) {
        return account.getPasswordCredentials().stream().filter(PasswordCredentials::isActive).findFirst().map(PasswordCredentials::getPassword).orElse("");
    }

    private Optional<Account> executeQuery(String sqlQuery, Map<String, ?> params) {
        EntityRowMapper entityRowMapper = this.getEntityRowMapper(Account.class);
        return this.jdbcClient.sql(sqlQuery).params(params).query((RowMapper)entityRowMapper).optional();
    }

    private <T> EntityRowMapper<T> getEntityRowMapper(Class<T> domainType) {
        return new EntityRowMapper(this.getRequiredPersistentEntity(domainType), this.jdbcConverter);
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.relationalMappingContext.getRequiredPersistentEntity(domainType);
    }
}

