/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.accessLevels;

import fr.obeo.ocp.application.permissions.services.api.IPermissionApplicationService;
import fr.obeo.perseus.server.common.services.api.AccessForbiddenException;
import fr.obeo.perseus.server.common.services.api.IProjectAccessLevelService;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jdbc.core.mapping.AggregateReference;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ProjectAccessLevelService
implements IProjectAccessLevelService {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectAccessLevelService.class);
    @Autowired
    private IPermissionApplicationService permissionApplicationService;

    public boolean hasAccessLevel(String projectId, String accessLevel) {
        Set accessLevels = this.permissionApplicationService.getCurrentUserProjectAccessLevels(AggregateReference.to((Object)projectId));
        return accessLevels.contains(accessLevel);
    }

    public void checkAccessLevel(String projectId, String accessLevel) throws AccessForbiddenException {
        if (!this.hasAccessLevel(projectId, accessLevel)) {
            LOG.warn(String.format("%s - Operation rejected because access level '%s' is required.", Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Principal::getName).orElse(null), accessLevel));
            throw new AccessForbiddenException(String.format("%s access level required.", accessLevel));
        }
    }
}

