/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.content;

import fr.obeo.perseus.server.dto.model.ModelDTO;
import fr.obeo.perseus.server.services.api.IModelService;
import fr.obeo.perseus.server.usersettings.services.api.IMetaclassFilter;
import fr.obeo.perseus.server.util.MetaclassPredicates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.sirius.components.core.api.IContentServiceDelegate;
import org.springframework.stereotype.Component;

@Component
public class ModelDTOContentServiceDelegate
implements IContentServiceDelegate {
    private final IModelService modelService;
    private final Supplier<IMetaclassFilter> metaclassFilterSupplier;

    public ModelDTOContentServiceDelegate(IModelService modelService, Supplier<IMetaclassFilter> metaclassFilterSupplier) {
        this.modelService = Objects.requireNonNull(modelService);
        this.metaclassFilterSupplier = Objects.requireNonNull(metaclassFilterSupplier);
    }

    public boolean canHandle(Object object) {
        return object instanceof ModelDTO;
    }

    public List<Object> getContents(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        IMetaclassFilter metaclassFilter = (IMetaclassFilter)this.metaclassFilterSupplier.get();
        Predicate monFilter = MetaclassPredicates.treeNodePredicate((IMetaclassFilter)metaclassFilter);
        long modelId = ((ModelDTO)object).getId();
        result.addAll(this.modelService.getRoots(modelId).filter(monFilter).toList());
        return result;
    }
}

