/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.content;

import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.services.api.ITreeNode;
import fr.obeo.perseus.server.services.api.dto.TypedModelObjectRef;
import fr.obeo.perseus.server.services.api.dto.model.RepresentationTypeNode;
import fr.obeo.perseus.server.services.api.dto.versioning.IntrinsicModelObjectData;
import fr.obeo.perseus.server.services.api.dto.versioning.MetaclassQNameFilter;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshot;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshotNode;
import fr.obeo.perseus.server.services.api.model.IModelID;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import fr.obeo.perseus.server.util.RepresentationComparator;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.sirius.components.core.api.IContentServiceDelegate;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectSnapshotNodeContentServiceDelegate
implements IContentServiceDelegate {
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final ICommitSearchService commitSearchService;
    private final RepresentationComparator representationComparator;
    private final Supplier<MetaclassQNameFilter> metaclassQNameFilterSupplier;

    public ModelObjectSnapshotNodeContentServiceDelegate(IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, ICommitSearchService commitSearchService, Supplier<MetaclassQNameFilter> metaclassQNameFilterSupplier, RepresentationComparator representationComparator) {
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.metaclassQNameFilterSupplier = Objects.requireNonNull(metaclassQNameFilterSupplier);
        this.representationComparator = Objects.requireNonNull(representationComparator);
    }

    public boolean canHandle(Object object) {
        return object instanceof ModelObjectSnapshotNode;
    }

    public List<Object> getContents(Object object) {
        ModelObjectSnapshotNode node = (ModelObjectSnapshotNode)object;
        List<Object> result = new ArrayList();
        if (node.snapshot().getIntrinsic().getMetaclass().isView()) {
            result = this.getViewChildren(node);
        } else {
            ModelSnapshotNode ims = node.model();
            MetaclassQNameFilter metaclassFilter = (MetaclassQNameFilter)this.metaclassQNameFilterSupplier.get();
            String projectId = ims.id().getProjectId();
            CommitID commitId = ims.commitId();
            List ids = Optional.ofNullable(node.snapshot().getIntrinsic().getTypedChildrenRefs()).map(typedChildrenRefs -> typedChildrenRefs.stream().map(TypedModelObjectRef::objectId).map(arg_0 -> ((IModelID)ims.id()).forObject(arg_0)).toList()).or(() -> Optional.ofNullable(node.snapshot().getIntrinsic().getPerseusContentExtension()).map(perseusContent -> perseusContent.stream().map(arg_0 -> ((IModelID)ims.id()).forObject(arg_0)).toList())).orElseGet(List::of);
            Map nodesByUid = this.commitSearchService.findCommit(projectId, commitId).map(commit -> this.modelObjectSnapshotSearchService.findModelObjectsInCommit((Collection)ids, commit)).orElseGet(Map::of);
            result = ids.stream().filter(nodesByUid::containsKey).map(moID -> {
                ModelObjectSnapshot mos = (ModelObjectSnapshot)nodesByUid.get(moID);
                return new ModelObjectSnapshotNode(ims, moID.getObjectId(), mos);
            }).filter(mosn -> metaclassFilter.test(mosn.snapshot().getIntrinsic().getMetaclass())).map(Object.class::cast).toList();
        }
        return result;
    }

    private List<Object> getViewChildren(ModelObjectSnapshotNode node) {
        ModelSnapshotNode ims = node.model();
        MetaclassQNameFilter metaclassFilter = (MetaclassQNameFilter)this.metaclassQNameFilterSupplier.get();
        String projectId = ims.id().getProjectId();
        CommitID commitId = ims.commitId();
        List ids = Optional.ofNullable(node.snapshot().getIntrinsic().getStructuralFeatureSettings().get("ownedRepresentationDescriptors")).filter(List.class::isInstance).map(List.class::cast).map(l -> l.stream().filter(String.class::isInstance).map(s -> ims.id().forObject((String)s)).toList()).orElseGet(List::of);
        List repDescriptors = this.commitSearchService.findCommit(projectId, commitId).map(commit -> this.modelObjectSnapshotSearchService.findModelObjectsInCommit((Collection)ids, commit)).map(m -> m.entrySet().stream().map(e -> new ModelObjectSnapshotNode(ims, ((IModelObjectID)e.getKey()).getObjectId(), (ModelObjectSnapshot)e.getValue())).filter(imos -> metaclassFilter.test(imos.snapshot().getIntrinsic().getMetaclass())).map(Object.class::cast).toList()).orElseGet(List::of);
        HashMap typesByDescriptors = new HashMap();
        repDescriptors.stream().filter(ModelObjectSnapshotNode.class::isInstance).map(ModelObjectSnapshotNode.class::cast).forEach(imos -> {
            Object repType;
            IntrinsicModelObjectData intrinsic = imos.snapshot().getIntrinsic();
            if (intrinsic.getMetaclass().isRepresentationDescriptor() && (repType = intrinsic.getStructuralFeatureSettings().get("representationType")) instanceof String) {
                String representationType = (String)repType;
                typesByDescriptors.put(imos.objectId(), representationType);
            }
        });
        HashMap typeNodes = new HashMap(typesByDescriptors.size());
        ArrayList repDescNodes = new ArrayList();
        repDescriptors.stream().filter(ModelObjectSnapshotNode.class::isInstance).map(ModelObjectSnapshotNode.class::cast).forEach(imos -> {
            String representationType = (String)typesByDescriptors.get(imos.objectId());
            if (representationType != null) {
                RepresentationTypeNode typeNode = typeNodes.computeIfAbsent(representationType, key -> new RepresentationTypeNode(new ModelObjectID(ims.id().getModelId(), node.objectId()), key, new ArrayList()));
                typeNode.getRepresentations().add(imos);
            } else {
                repDescNodes.add(imos);
            }
        });
        ArrayList representationTypes = new ArrayList(typeNodes.values());
        for (ITreeNode tn : representationTypes) {
            if (!(tn instanceof RepresentationTypeNode)) continue;
            ((RepresentationTypeNode)tn).getRepresentations().sort(this.representationComparator);
        }
        representationTypes.sort(Comparator.naturalOrder());
        repDescNodes.sort(this.representationComparator);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(representationTypes);
        result.addAll(repDescNodes);
        return result;
    }
}

