/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.content;

import fr.obeo.perseus.server.services.api.dto.versioning.MetaclassQNameFilter;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshot;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshotNode;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.sirius.components.core.api.IContentServiceDelegate;
import org.springframework.stereotype.Component;

@Component
public class ModelSnapshotNodeContentServiceDelegate
implements IContentServiceDelegate {
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final ICommitSearchService commitSearchService;
    private final Supplier<MetaclassQNameFilter> metaclassQNameFilterSupplier;

    public ModelSnapshotNodeContentServiceDelegate(IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, ICommitSearchService commitSearchService, Supplier<MetaclassQNameFilter> metaclassQNameFilterSupplier) {
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.commitSearchService = Objects.requireNonNull(commitSearchService);
        this.metaclassQNameFilterSupplier = Objects.requireNonNull(metaclassQNameFilterSupplier);
    }

    public boolean canHandle(Object object) {
        return object instanceof ModelSnapshotNode;
    }

    public List<Object> getContents(Object object) {
        ModelSnapshotNode ims = (ModelSnapshotNode)object;
        MetaclassQNameFilter metaclassFilter = (MetaclassQNameFilter)this.metaclassQNameFilterSupplier.get();
        String projectId = ims.id().getProjectId();
        CommitID commitId = ims.commitId();
        List<IModelObjectID> ids = ims.snapshot().derived().roots().stream().map(ref -> ims.id().forObject(ref.objectId())).toList();
        Map nodesByUid = this.commitSearchService.findCommit(projectId, commitId).map(commit -> this.modelObjectSnapshotSearchService.findModelObjectsInCommit((Collection)ids, commit)).orElseGet(Map::of);
        return ids.stream().filter(nodesByUid::containsKey).map(moID -> {
            ModelObjectSnapshot mos = (ModelObjectSnapshot)nodesByUid.get(moID);
            return new ModelObjectSnapshotNode(ims, moID.getObjectId(), mos);
        }).filter(mosn -> metaclassFilter.test(mosn.snapshot().getIntrinsic().getMetaclass())).map(Object.class::cast).toList();
    }
}

