/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.debug;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.IBaseline;
import fr.obeo.perseus.server.versioning.IBranch;
import fr.obeo.perseus.server.versioning.ICommit;
import fr.obeo.perseus.server.versioning.IHistory;
import fr.obeo.perseus.server.versioning.IResourceState;
import fr.obeo.perseus.server.versioning.api.IBranchSearchService;
import fr.obeo.perseus.server.versioning.api.ICommitSearchService;
import fr.obeo.perseus.server.versioning.repositories.IBaselineRepository;
import fr.obeo.perseus.server.versioning.repositories.IBranchRepository;
import fr.obeo.perseus.server.versioning.repositories.ICommitRepository;
import fr.obeo.perseus.server.versioning.repositories.IResourceStateRepository;
import fr.obeo.perseus.server.versioning.repositories.IStateRepository;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"dev"})
public class DebugHistoryService {
    @Autowired
    private IBranchRepository branchRepository;
    @Autowired
    private IBaselineRepository baselineRepository;
    @Autowired
    private ICommitRepository commitRepository;
    @Autowired
    private IResourceStateRepository resourceStateRepository;
    @Autowired
    private IStateRepository stateRepository;
    @Autowired
    private IHistoryOfModelSearchService historyOfModelSearchService;
    @Autowired
    private IBranchSearchService branchSearchService;
    @Autowired
    private ICommitSearchService commitSearchService;

    public Map<Object, Object> exportModelHistory(String projectId, long modelId) {
        return this.historyOfModelSearchService.findModelHistory(projectId, modelId).map(arg_0 -> this.exportHistory(arg_0)).orElseThrow();
    }

    public List<Map<Object, Object>> exportModelObjectHistory(String projectId, long modelId, String objectId, Integer limit) {
        IHistory modelHistory = (IHistory)this.historyOfModelSearchService.findModelHistory(projectId, modelId).get();
        List commits = this.commitSearchService.getCommits(modelHistory, objectId, Optional.empty(), limit.intValue());
        return commits.stream().map(commit -> this.exportCommit(commit, Optional.of(objectId))).toList();
    }

    public Map<Object, Object> exportCommit(String projectId, long modelId, Optional<UUID> branchId, int version) {
        IHistory history = (IHistory)this.historyOfModelSearchService.findModelHistory(projectId, modelId).orElseThrow();
        CommitID commitId = new CommitID(branchId.orElseGet(() -> ((IBranch)this.branchSearchService.findBranchesByTitle(history, "Master").get(0)).getId()), version);
        ICommit commit = (ICommit)this.commitRepository.findById((Object)commitId).orElseThrow();
        return this.exportCommit(commit, Optional.empty());
    }

    private Map<Object, Object> exportHistory(IHistory entity) {
        List<IBaseline> baselines;
        LinkedHashMap<Object, Object> export = new LinkedHashMap<Object, Object>();
        List<IBranch> branches = this.branchRepository.findAll().stream().filter(branch -> branch.getHistoryId().equals(entity.getId())).sorted((b1, b2) -> b1.getId().compareTo(b2.getId())).toList();
        if (!branches.isEmpty()) {
            export.put("branches", branches.stream().map(branch -> this.exportBranch(branch)).toList());
        }
        if (!(baselines = this.baselineRepository.findAll().stream().filter(baseline -> baseline.getHistoryId().equals(entity.getId())).sorted((t1, t2) -> t1.getId().compareTo(t2.getId())).toList()).isEmpty()) {
            export.put("baselines", baselines.stream().map(arg_0 -> this.exportTag(arg_0)).toList());
        }
        return export;
    }

    private Map<Object, Object> exportBranch(IBranch entity) {
        LinkedHashMap<Object, Object> export = new LinkedHashMap<Object, Object>();
        export.put("title", entity.getTitle());
        if (entity.isArchived()) {
            export.put("isArchived", entity.isArchived());
        }
        export.put("createdBy", entity.getCreatedBy());
        if (entity.getModifiedBy() != null) {
            export.put("modifiedBy", entity.getModifiedBy());
        }
        if (entity.getStartingPoint().isPresent()) {
            export.put("startingPointBranchTitle", ((IBranch)this.branchRepository.findById((Object)((CommitID)entity.getStartingPoint().get()).getBranchId()).get()).getTitle());
            export.put("startingPoinVersion", ((CommitID)entity.getStartingPoint().get()).getVersion());
        }
        List commits = this.commitRepository.findAll().stream().filter(commit -> commit.getId().getBranchId().equals(entity.getId())).sorted((c1, c2) -> Integer.compare(c1.getId().getVersion(), c2.getId().getVersion())).collect(Collectors.toList());
        Collections.reverse(commits);
        if (!commits.isEmpty()) {
            export.put("commits", commits.stream().map(commit -> this.exportCommit(commit, Optional.empty())).toList());
        }
        return export;
    }

    private Map<Object, Object> exportTag(IBaseline entity) {
        LinkedHashMap<Object, Object> export = new LinkedHashMap<Object, Object>();
        export.put("title", entity.getTitle());
        export.put("createdBy", entity.getCreatedBy());
        export.put("modifiedBy", entity.getModifiedBy());
        export.put("commitBranchTitle", ((IBranch)this.branchRepository.findById((Object)entity.getCommitId().getBranchId()).get()).getTitle());
        export.put("commitVersion", entity.getCommitId().getVersion());
        return export;
    }

    private Map<Object, Object> exportCommit(ICommit entity, Optional<String> objectId) {
        List<Map> resourceStates = objectId.isPresent() ? this.resourceStateRepository.findByCommitId(entity.getId()).stream().filter(resourceState -> resourceState.getUri().endsWith((String)objectId.get())).sorted((rs1, rs2) -> rs1.getUri().compareTo(rs2.getUri())).map(arg_0 -> this.exportResourceState(arg_0)).toList() : this.resourceStateRepository.findByCommitId(entity.getId()).stream().sorted((rs1, rs2) -> rs1.getUri().compareTo(rs2.getUri())).map(arg_0 -> this.exportResourceState(arg_0)).toList();
        LinkedHashMap<Object, Object> export = new LinkedHashMap<Object, Object>();
        export.put("version", entity.getId().getVersion());
        export.put("message", entity.getMessage());
        export.put("commiter", entity.getCommitter());
        export.put("props", entity.getProps());
        export.put("resourceStates", resourceStates);
        return export;
    }

    private Map<Object, Object> exportResourceState(IResourceState entity) {
        LinkedHashMap<Object, Object> export = new LinkedHashMap<Object, Object>();
        export.put("uri", entity.getUri());
        export.put("state", entity.getStateHash().map(arg_0 -> this.getState(arg_0)).orElse(null));
        return export;
    }

    private Object getState(String hash) {
        return this.stateRepository.findById((Object)hash).map(state -> {
            JsonNode jsonNode;
            block8: {
                InputStream dataAsStream = state.getDataAsStream();
                try {
                    jsonNode = new ObjectMapper().reader().readTree(dataAsStream);
                    if (dataAsStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataAsStream != null) {
                            try {
                                dataAsStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                dataAsStream.close();
            }
            return jsonNode;
        }).orElse(null);
    }
}

