/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.label;

import fr.obeo.perseus.server.services.api.IIconService;
import fr.obeo.perseus.server.services.api.dto.versioning.DerivedModelData;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelSnapshotNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.core.api.ILabelServiceDelegate;
import org.eclipse.sirius.components.core.api.labels.StyledString;
import org.springframework.stereotype.Component;

@Component
public class ModelSnapshotNodeLabelServiceDelegate
implements ILabelServiceDelegate {
    private final IIconService iconService;

    public ModelSnapshotNodeLabelServiceDelegate(IIconService iconService) {
        this.iconService = Objects.requireNonNull(iconService);
    }

    public boolean canHandle(Object object) {
        return object instanceof ModelSnapshotNode;
    }

    public StyledString getStyledLabel(Object object) {
        return StyledString.of((String)((ModelSnapshotNode)object).snapshot().intrinsic().getName());
    }

    public List<String> getImagePaths(Object object) {
        String imageURL = Optional.ofNullable(((ModelSnapshotNode)object).snapshot().derived()).flatMap(DerivedModelData::iconHash).map(hash -> this.iconService.getModelIconPath(hash)).orElse("/static/images/model.png");
        return List.of(imageURL);
    }
}

