/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.sb;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.common.LabelUtil;
import fr.obeo.perseus.server.oauth.services.api.IOAuthFriendService;
import fr.obeo.perseus.server.oslc.api.IOslcLinkService;
import fr.obeo.perseus.server.oslc.api.IOslcLinkingConfigurationHelper;
import fr.obeo.perseus.server.oslc.api.graphql.OslcLinkType;
import fr.obeo.perseus.server.oslc.dto.OslcLinkData;
import fr.obeo.perseus.server.oslc.globalconf.api.IGlobalConfService;
import fr.obeo.perseus.server.repositories.IExtConfigurationRepository;
import fr.obeo.perseus.server.services.HTMLSanitizer;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.core.api.ILabelService;
import org.eclipse.sirius.components.emf.forms.api.IPropertiesValidationProvider;
import org.eclipse.sirius.components.forms.TreeNode;
import org.eclipse.sirius.components.forms.description.TreeDescription;
import org.eclipse.sirius.components.representations.Success;
import org.eclipse.sirius.components.representations.VariableManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.NonNull;

public class OslcLinksTreeProvider {
    private static final String WIDGET_ID = "SemanticBrowser";
    private static final String LINK_ICON_URL = "/static/images/link_black_24dp.svg";
    @NonNull
    private final IIdentityService identityService;
    @NonNull
    private final ILabelService labelService;
    @NonNull
    private final IOslcLinkService oslcLinkService;
    @NonNull
    private final ExecutorService oslcExecutorService;
    @NonNull
    private final IOAuthFriendService oauthFriendService;
    @NonNull
    private final IGlobalConfService globalConfService;
    private final Function<VariableManager, String> semanticTargetIdProvider;
    private final IPropertiesValidationProvider propertiesValidationProvider = new IPropertiesValidationProvider.NoOp();
    private final HTMLSanitizer htmlSanitizer;
    private final IExtConfigurationRepository extConfigurationRepository;

    public OslcLinksTreeProvider(IIdentityService identityService, ILabelService labelService, IOslcLinkService oslcLinkService, @Qualifier(value="oslcExecutorService") ExecutorService oslcExecutorService, IOAuthFriendService oauthFriendService, IGlobalConfService globalConfService, HTMLSanitizer htmlSanitizer, IExtConfigurationRepository extConfigurationRepository) {
        this.identityService = Objects.requireNonNull(identityService);
        this.labelService = Objects.requireNonNull(labelService);
        this.oslcLinkService = Objects.requireNonNull(oslcLinkService);
        this.globalConfService = Objects.requireNonNull(globalConfService);
        this.oslcExecutorService = Objects.requireNonNull(oslcExecutorService);
        this.oauthFriendService = Objects.requireNonNull(oauthFriendService);
        this.htmlSanitizer = Objects.requireNonNull(htmlSanitizer);
        this.semanticTargetIdProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElse(null);
        this.extConfigurationRepository = extConfigurationRepository;
    }

    public TreeDescription getTreeDescription() {
        return TreeDescription.newTreeDescription((String)WIDGET_ID).idProvider(variableManager -> "oslc::links").targetObjectIdProvider(this.semanticTargetIdProvider).labelProvider(variableManager -> "External Links").iconURLProvider(variableManager -> List.of(LINK_ICON_URL)).nodeIdProvider(arg_0 -> this.getNodeId(arg_0)).nodeLabelProvider(arg_0 -> this.getNodeLabel(arg_0)).nodeIconURLProvider(arg_0 -> this.getNodeIconURL(arg_0)).nodeKindProvider(arg_0 -> this.getNodeKind(arg_0)).nodeSelectableProvider(arg_0 -> this.isNodeSelectable(arg_0)).nodeEndIconsURLProvider(variableManager -> List.of()).childrenProvider(arg_0 -> this.getCurrentChildren(arg_0)).isCheckableProvider(variableManager -> false).checkedValueProvider(variableManager -> false).newCheckedValueHandler((variableManager, newValue) -> new Success()).expandedNodeIdsProvider(arg_0 -> this.collectAllNodeIds(arg_0)).diagnosticsProvider(this.propertiesValidationProvider.getDiagnosticsProvider()).kindProvider(this.propertiesValidationProvider.getKindProvider()).messageProvider(this.propertiesValidationProvider.getMessageProvider()).build();
    }

    private List<?> getCurrentChildren(VariableManager variableManager) {
        return variableManager.get("self", Object.class).flatMap(self -> variableManager.get("editingContext", Object.class).map(editingContext -> {
            if (editingContext instanceof ProjectEditingContext) {
                ProjectEditingContext pec = (ProjectEditingContext)editingContext;
                return this.getCurrentNodeChildren(self, pec.getProjectId(), variableManager);
            }
            if (editingContext instanceof CommitEditingContext) {
                CommitEditingContext cec = (CommitEditingContext)editingContext;
                return this.getCurrentSnapshotChildren(self, cec, variableManager);
            }
            return List.of();
        })).orElseGet(List::of);
    }

    private List<?> getCurrentNodeChildren(Object self, String projectId, VariableManager variableManager) {
        List result;
        if (self instanceof ModelObjectNode) {
            ModelObjectNode node = (ModelObjectNode)self;
            result = this.getModelObjectNodeChildren(node, projectId, variableManager);
        } else if (self instanceof OslcLinkType) {
            OslcLinkType dto = (OslcLinkType)self;
            result = this.getOslcLinkTypeChildren(dto, variableManager);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<?> getCurrentSnapshotChildren(Object self, CommitEditingContext cec, VariableManager variableManager) {
        List result;
        if (self instanceof ModelObjectSnapshotNode) {
            ModelObjectSnapshotNode node = (ModelObjectSnapshotNode)self;
            result = this.getModelObjectSnapshotChildren(node, variableManager);
        } else if (self instanceof OslcLinkType) {
            OslcLinkType dto = (OslcLinkType)self;
            result = this.getOslcLinkTypeChildren(dto, variableManager);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<?> getModelObjectNodeChildren(ModelObjectNode mon, String projectId, VariableManager variableManager) {
        String objectId = mon.getId();
        long modelId = mon.getModelId();
        Map linksByType = this.oslcLinkService.getOslcLinksByTypeForModelObject(projectId, modelId, objectId);
        linksByType.entrySet().stream().forEach(entry -> {
            List varLinksByType = (List)((Map)variableManager.get("linksByType", Map.class).get()).computeIfAbsent(entry.getKey(), key -> new ArrayList());
            varLinksByType.addAll((Collection)entry.getValue());
        });
        ArrayList result = new ArrayList(linksByType.keySet());
        result.sort((lt1, lt2) -> {
            if (lt1.getLabel() == null) {
                return lt2.getLabel() == null ? 0 : -1;
            }
            return lt1.getLabel().compareTo(lt2.getLabel());
        });
        return result;
    }

    private List<?> getModelObjectSnapshotChildren(ModelObjectSnapshotNode node, VariableManager variableManager) {
        List links = node.snapshot().getLinks();
        if (links == null) {
            return List.of();
        }
        Optional oslcLinkingConfig = variableManager.get("oslcLinkingConfig", IOslcLinkingConfigurationHelper.class);
        List result = links.stream().map(lbt -> {
            String uri = lbt.getTypeUri();
            URI typeUri = URI.create(uri);
            OslcLinkType linkType = oslcLinkingConfig.flatMap(helper -> helper.findLinkType(typeUri)).orElseGet(() -> new OslcLinkType(typeUri, uri, null));
            List<OslcLinkData> linkDataList = lbt.getResources().stream().map(link -> new OslcLinkData(UUID.randomUUID(), link.getResource(), Optional.empty(), link.getTitle())).toList();
            ((Map)variableManager.get("linksByType", Map.class).get()).put(linkType, linkDataList);
            return linkType;
        }).collect(Collectors.toCollection(() -> new ArrayList(links.size())));
        result.sort((lt1, lt2) -> {
            if (lt1.getLabel() == null) {
                return lt2.getLabel() == null ? 0 : -1;
            }
            return lt1.getLabel().compareTo(lt2.getLabel());
        });
        return result;
    }

    private List<?> getOslcLinkTypeChildren(OslcLinkType linkType, VariableManager variableManager) {
        Map linksByType = (Map)variableManager.get("linksByType", Map.class).get();
        return (List)linksByType.get(linkType);
    }

    private String getNodeId(VariableManager variableManager) {
        Object result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode) {
            ModelObjectNode motn = self;
            result = "mon/" + motn.getId();
        } else if (self instanceof OslcLinkData) {
            OslcLinkData link = self;
            result = link.id().toString() + "#" + link.artifactUrl();
        } else if (self instanceof OslcLinkType) {
            OslcLinkType type = self;
            result = UUID.nameUUIDFromBytes(String.valueOf(type.getUri()).getBytes()).toString();
        } else if (self != null) {
            result = this.identityService.getId(self);
        }
        return result;
    }

    private String getNodeLabel(VariableManager variableManager) {
        String result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode) {
            result = ((ModelObjectNode)self).getLabel();
        } else if (self instanceof OslcLinkData) {
            OslcLinkData link = self;
            result = this.htmlSanitizer.sanitizeHTML(String.valueOf(link.title()));
        } else if (self instanceof OslcLinkType) {
            OslcLinkType type = self;
            result = String.valueOf(type.getLabel());
        } else if (self != null) {
            result = LabelUtil.getTruncatedLabel((String)this.labelService.getStyledLabel(self).toString());
        }
        if (result == null) {
            result = "<Unnamed>";
        }
        return result;
    }

    private List<String> getNodeIconURL(VariableManager variableManager) {
        List result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode) {
            result = List.of(LINK_ICON_URL);
        } else if (self instanceof OslcLinkData) {
            result = List.of(LINK_ICON_URL);
        } else if (self instanceof OslcLinkType) {
            result = List.of("/static/images/ExternalLink.png");
        } else if (self != null) {
            result = this.labelService.getImagePaths(self);
        }
        return result;
    }

    private String getNodeKind(VariableManager variableManager) {
        String result = null;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof ModelObjectNode) {
            result = "perseus://ModelObject";
        } else if (self instanceof OslcLinkData) {
            result = "perseus://ExtLink";
        } else if (self instanceof OslcLinkType) {
            result = "obeoStudio://category";
        } else if (self != null) {
            result = this.identityService.getKind(self);
        }
        return result;
    }

    private boolean isNodeSelectable(VariableManager variableManager) {
        boolean result = false;
        Object self = variableManager.get("self", Object.class).orElse(null);
        if (self instanceof OslcLinkData) {
            result = false;
        }
        return result;
    }

    private List<String> collectAllNodeIds(VariableManager variableManager) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : variableManager.get("nodes", List.class).orElse(List.of())) {
            if (!(element instanceof TreeNode)) continue;
            TreeNode node = (TreeNode)element;
            result.add(node.getId());
        }
        return result;
    }
}

