/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.sb;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.app.services.sb.OslcLinksTreeProvider;
import fr.obeo.perseus.server.app.services.sb.SemanticBrowserDescriptionProvider;
import fr.obeo.perseus.server.app.services.sb.SemanticBrowserPanel;
import fr.obeo.perseus.server.app.services.sb.SemanticBrowserPanelKind;
import fr.obeo.perseus.server.app.services.sb.SemanticBrowserTreeProvider;
import fr.obeo.perseus.server.oauth.services.api.IOAuthFriendService;
import fr.obeo.perseus.server.oslc.api.IOslcLinkService;
import fr.obeo.perseus.server.oslc.api.IOslcLinkingConfigurationHelper;
import fr.obeo.perseus.server.oslc.api.IOslcLinkingConfigurationService;
import fr.obeo.perseus.server.oslc.globalconf.api.IGlobalConfService;
import fr.obeo.perseus.server.repositories.IExtConfigurationRepository;
import fr.obeo.perseus.server.services.HTMLSanitizer;
import fr.obeo.perseus.server.services.api.dto.model.ModelObjectNode;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshotNode;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.semanticbrowser.ISemanticBrowserService;
import fr.obeo.perseus.server.services.api.semanticbrowser.SemanticBrowserContainer;
import fr.obeo.perseus.server.services.api.semanticbrowser.SemanticBrowserInput;
import fr.obeo.perseus.server.services.versioning.SBSnapshotToTreeNodeVisitor;
import fr.obeo.perseus.server.versioning.ICommit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.eclipse.sirius.components.collaborative.forms.api.IRelatedElementsDescriptionProvider;
import org.eclipse.sirius.components.core.api.IIdentityService;
import org.eclipse.sirius.components.core.api.ILabelService;
import org.eclipse.sirius.components.forms.GroupDisplayMode;
import org.eclipse.sirius.components.forms.description.ForDescription;
import org.eclipse.sirius.components.forms.description.FormDescription;
import org.eclipse.sirius.components.forms.description.GroupDescription;
import org.eclipse.sirius.components.forms.description.IfDescription;
import org.eclipse.sirius.components.forms.description.PageDescription;
import org.eclipse.sirius.components.representations.GetOrCreateRandomIdProvider;
import org.eclipse.sirius.components.representations.VariableManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Service;

@Service
@Primary
public class SemanticBrowserDescriptionProvider
implements IRelatedElementsDescriptionProvider {
    public static final String VAR_SB_PANEL_ITERATOR = "sbPanel";
    public static final String VAR_OSLC_LINKING_CONFIG = "oslcLinkingConfig";
    public static final String VAR_LINKS_BY_TYPE = "linksByType";
    public static final String VAR_EDITING_CONTEXT = "editingContext";
    public static final String KIND_CATEGORY = "obeoStudio://category";
    public static final String KIND_MODEL_OBJECT = "perseus://ModelObject";
    public static final String KIND_EXTERNAL_LINK = "perseus://ExtLink";
    public static final UUID FORM_DESCRIPTION_ID = UUID.nameUUIDFromBytes("relatedElementsForm".getBytes());
    private static final String GROUP_DESCRIPTION_ID = "relatedElementsGroup";
    private static final String PAGE_DESCRIPTION_ID = "relatedElementsPage";
    private final IIdentityService identityService;
    private final ILabelService labelService;
    private final ISemanticBrowserService semanticBrowserService;
    private final IOslcLinkingConfigurationService oslcLinkingConfigurationService;
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final IOslcLinkService oslcLinkService;
    private final ExecutorService oslcExecutorService;
    private final MessageSourceAccessor modelAppMessageSourceAccessor;
    private final IOAuthFriendService oauthFriendService;
    private final IGlobalConfService globalConfService;
    private final Function<VariableManager, String> semanticTargetIdProvider;
    private HTMLSanitizer htmlSanitizer;
    private final IExtConfigurationRepository extConfigurationRepository;

    public SemanticBrowserDescriptionProvider(IIdentityService identityService, ILabelService labelService, ISemanticBrowserService semanticBrowserService, IOslcLinkingConfigurationService oslcLinkingConfigurationService, IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, IOslcLinkService oslcLinkService, @Qualifier(value="oslcExecutorService") ExecutorService oslcExecutorService, @Qualifier(value="modelAppMessageSourceAccessor") MessageSourceAccessor msgAccessor, IOAuthFriendService oauthFriendService, IGlobalConfService globalConfService, HTMLSanitizer htmlSanitizer, IExtConfigurationRepository extConfigurationRepository) {
        this.identityService = Objects.requireNonNull(identityService);
        this.labelService = Objects.requireNonNull(labelService);
        this.semanticBrowserService = Objects.requireNonNull(semanticBrowserService);
        this.oslcLinkingConfigurationService = Objects.requireNonNull(oslcLinkingConfigurationService);
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.oslcLinkService = Objects.requireNonNull(oslcLinkService);
        this.globalConfService = Objects.requireNonNull(globalConfService);
        this.oslcExecutorService = Objects.requireNonNull(oslcExecutorService);
        this.modelAppMessageSourceAccessor = Objects.requireNonNull(msgAccessor);
        this.oauthFriendService = Objects.requireNonNull(oauthFriendService);
        this.htmlSanitizer = Objects.requireNonNull(htmlSanitizer);
        this.semanticTargetIdProvider = variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElse(null);
        this.extConfigurationRepository = extConfigurationRepository;
    }

    public FormDescription getFormDescription() {
        List<GroupDescription> groupDescriptions = List.of(GroupDescription.newGroupDescription((String)GROUP_DESCRIPTION_ID).idProvider(variableManager -> "Related Elements").labelProvider(variableManager -> this.modelAppMessageSourceAccessor.getMessage("sb.form.label")).displayModeProvider(variableManager -> GroupDisplayMode.TOGGLEABLE_AREAS).semanticElementsProvider(variableManager -> {
            variableManager.put(VAR_LINKS_BY_TYPE, new LinkedHashMap());
            variableManager.get(VAR_EDITING_CONTEXT, CommitEditingContext.class).ifPresent(cec -> {
                String projectId = cec.getProjectId();
                IOslcLinkingConfigurationHelper oslcConfiguration = this.oslcLinkingConfigurationService.findOslcConfiguration(projectId).orElseGet(() -> ((IOslcLinkingConfigurationService)this.oslcLinkingConfigurationService).getDefaultOslcConfiguration());
                variableManager.put(VAR_OSLC_LINKING_CONFIG, (Object)oslcConfiguration);
            });
            return variableManager.get("self", Object.class).stream().toList();
        }).controlDescriptions(List.of(this.ifIsNode(), this.ifIsSnapshot())).build());
        return FormDescription.newFormDescription((String)FORM_DESCRIPTION_ID.toString()).label(this.modelAppMessageSourceAccessor.getMessage("sb.form.label")).idProvider((Function)new GetOrCreateRandomIdProvider()).labelProvider(variableManager -> this.modelAppMessageSourceAccessor.getMessage("sb.form.label")).targetObjectIdProvider(this.semanticTargetIdProvider).canCreatePredicate(variableManager -> false).pageDescriptions(List.of(PageDescription.newPageDescription((String)PAGE_DESCRIPTION_ID).idProvider(variableManager -> variableManager.get("self", Object.class).map(arg_0 -> ((IIdentityService)this.identityService).getId(arg_0)).orElseGet(() -> UUID.randomUUID().toString())).labelProvider(variableManager -> this.modelAppMessageSourceAccessor.getMessage("sb.form.label")).semanticElementsProvider(variableManager -> variableManager.get("self", Object.class).stream().toList()).groupDescriptions(groupDescriptions).canCreatePredicate(variableManager -> true).build())).iconURLsProvider(variableManager -> List.of()).build();
    }

    private IfDescription ifIsNode() {
        return IfDescription.newIfDescription((String)"ifIsNode").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isModelObjectNode(arg_0)).controlDescriptions(List.of(ForDescription.newForDescription((String)"forEachPanel").targetObjectIdProvider(this.semanticTargetIdProvider).iterator(VAR_SB_PANEL_ITERATOR).iterableProvider(arg_0 -> this.getNodePanels(arg_0)).controlDescriptions(List.of(IfDescription.newIfDescription((String)"ifSBPanel").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(variableManager -> variableManager.get(VAR_SB_PANEL_ITERATOR, SemanticBrowserPanel.class).isPresent()).controlDescriptions(List.of(new SemanticBrowserTreeProvider(this.identityService, this.labelService, this.modelAppMessageSourceAccessor).getTreeDescription())).build(), IfDescription.newIfDescription((String)"ifOslcLinksPanel").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(variableManager -> variableManager.get(VAR_SB_PANEL_ITERATOR, OslcLinksPanel.class).isPresent()).controlDescriptions(List.of(new OslcLinksTreeProvider(this.identityService, this.labelService, this.oslcLinkService, this.oslcExecutorService, this.oauthFriendService, this.globalConfService, this.htmlSanitizer, this.extConfigurationRepository).getTreeDescription())).build())).build())).build();
    }

    private IfDescription ifIsSnapshot() {
        return IfDescription.newIfDescription((String)"ifIsSnapshot").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(arg_0 -> this.isModelObjectSnapshot(arg_0)).controlDescriptions(List.of(ForDescription.newForDescription((String)"forEachPanel").targetObjectIdProvider(this.semanticTargetIdProvider).iterator(VAR_SB_PANEL_ITERATOR).iterableProvider(arg_0 -> this.getSnapshotPanels(arg_0)).controlDescriptions(List.of(IfDescription.newIfDescription((String)"ifSBPanel").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(variableManager -> variableManager.get(VAR_SB_PANEL_ITERATOR, SemanticBrowserPanel.class).isPresent()).controlDescriptions(List.of(new SemanticBrowserTreeProvider(this.identityService, this.labelService, this.modelAppMessageSourceAccessor).getTreeDescription())).build(), IfDescription.newIfDescription((String)"ifOslcLinksPanel").targetObjectIdProvider(this.semanticTargetIdProvider).predicate(variableManager -> variableManager.get(VAR_SB_PANEL_ITERATOR, OslcLinksPanel.class).isPresent()).controlDescriptions(List.of(new OslcLinksTreeProvider(this.identityService, this.labelService, this.oslcLinkService, this.oslcExecutorService, this.oauthFriendService, this.globalConfService, this.htmlSanitizer, this.extConfigurationRepository).getTreeDescription())).build())).build())).build();
    }

    private boolean isModelObjectNode(VariableManager variableManager) {
        return variableManager.get(VAR_EDITING_CONTEXT, ProjectEditingContext.class).isPresent() && variableManager.get("self", ModelObjectNode.class).isPresent();
    }

    private boolean isModelObjectSnapshot(VariableManager variableManager) {
        return variableManager.get(VAR_EDITING_CONTEXT, CommitEditingContext.class).isPresent() && variableManager.get("self", ModelObjectSnapshotNode.class).isPresent();
    }

    private List<Object> getNodePanels(VariableManager variableManager) {
        return variableManager.get(VAR_EDITING_CONTEXT, ProjectEditingContext.class).flatMap(editingContext -> variableManager.get("self", ModelObjectNode.class).map(node -> this.getSbPanels(editingContext, node))).orElseGet(List::of);
    }

    private List<Object> getSnapshotPanels(VariableManager variableManager) {
        return variableManager.get(VAR_EDITING_CONTEXT, CommitEditingContext.class).flatMap(editingContext -> variableManager.get("self", ModelObjectSnapshotNode.class).map(node -> this.getSbPanels(variableManager, editingContext, node))).orElseGet(List::of);
    }

    private List<Object> getSbPanels(VariableManager variableManager, CommitEditingContext editingContext, ModelObjectSnapshotNode imos) {
        SemanticBrowserContainer sbc = SBSnapshotToTreeNodeVisitor.convert((ModelObjectSnapshotNode)imos, (ICommit)editingContext.getCommit(), (IModelObjectSnapshotSearchService)this.modelObjectSnapshotSearchService);
        return List.of(new SemanticBrowserPanel(SemanticBrowserPanelKind.INCOMING, sbc), new SemanticBrowserPanel(SemanticBrowserPanelKind.CURRENT, sbc), new SemanticBrowserPanel(SemanticBrowserPanelKind.OUTGOING, sbc), OslcLinksPanel.INSTANCE);
    }

    private List<Object> getSbPanels(ProjectEditingContext editingContext, ModelObjectNode node) {
        SemanticBrowserContainer container = this.semanticBrowserService.getSemanticBrowser(new SemanticBrowserInput(UUID.randomUUID(), editingContext.getProjectId(), node.getModelId(), node.getId()));
        List<OslcLinksPanel> result = List.of(new SemanticBrowserPanel(SemanticBrowserPanelKind.INCOMING, container), new SemanticBrowserPanel(SemanticBrowserPanelKind.CURRENT, container), new SemanticBrowserPanel(SemanticBrowserPanelKind.OUTGOING, container), OslcLinksPanel.INSTANCE);
        return result;
    }
}

