/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.versioning;

import fr.obeo.perseus.server.app.services.versioning.BaselineCreatedInput;
import fr.obeo.perseus.server.services.api.dto.versioning.CreateBaselineInput;
import fr.obeo.perseus.server.util.ModelEntityToDTO;
import fr.obeo.perseus.server.versioning.events.BaselineCreated;
import java.util.Objects;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.graphql.api.IEditingContextDispatcher;
import org.eclipse.sirius.web.application.project.services.api.IProjectEditingContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class NotifyEditingContextOnBaselineCreated
implements ApplicationListener<BaselineCreated> {
    private static final Logger LOG = LoggerFactory.getLogger(NotifyEditingContextOnBaselineCreated.class);
    private final IEditingContextDispatcher editingContextDispatcher;
    private final IProjectEditingContextService projectEditingContextService;
    private final ModelEntityToDTO modelEntityToDTO;

    public NotifyEditingContextOnBaselineCreated(IEditingContextDispatcher editingContextDispatcher, IProjectEditingContextService projectEditingContextService, ModelEntityToDTO modelEntityToDTO) {
        this.editingContextDispatcher = Objects.requireNonNull(editingContextDispatcher);
        this.projectEditingContextService = Objects.requireNonNull(projectEditingContextService);
        this.modelEntityToDTO = Objects.requireNonNull(modelEntityToDTO);
    }

    public void onApplicationEvent(BaselineCreated event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Received TagCreated %s", event));
        }
        fr.obeo.perseus.server.versioning.api.CreateBaselineInput versioningInput = (fr.obeo.perseus.server.versioning.api.CreateBaselineInput)event.getSource();
        CreateBaselineInput appInput = (CreateBaselineInput)versioningInput.causedBy();
        String projectId = appInput.projectId();
        long modelId = appInput.modelId();
        this.editingContextDispatcher.dispatchMutation(appInput.editingContextId(), (IInput)new BaselineCreatedInput(versioningInput.id(), modelId, this.modelEntityToDTO.convert(event.getTag())));
        this.projectEditingContextService.getEditingContextId(projectId).filter(editingContextId -> !editingContextId.equals(appInput.editingContextId())).ifPresent(editingContextId -> this.editingContextDispatcher.dispatchMutation(editingContextId, (IInput)new BaselineCreatedInput(versioningInput.id(), modelId, this.modelEntityToDTO.convert(event.getTag()))));
    }
}

