/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.services.versioning;

import fr.obeo.perseus.server.app.services.versioning.BaselineDeletedInput;
import fr.obeo.perseus.server.services.api.dto.versioning.DeleteBaselineInput;
import fr.obeo.perseus.server.versioning.events.BaselineDeleted;
import java.util.Objects;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.graphql.api.IEditingContextDispatcher;
import org.eclipse.sirius.web.application.project.services.api.IProjectEditingContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class NotifyEditingContextOnBaselineDeleted
implements ApplicationListener<BaselineDeleted> {
    private static final Logger LOG = LoggerFactory.getLogger(NotifyEditingContextOnBaselineDeleted.class);
    private final IEditingContextDispatcher editingContextDispatcher;
    private final IProjectEditingContextService projectEditingContextService;

    public NotifyEditingContextOnBaselineDeleted(IEditingContextDispatcher editingContextDispatcher, IProjectEditingContextService projectEditingContextService) {
        this.editingContextDispatcher = Objects.requireNonNull(editingContextDispatcher);
        this.projectEditingContextService = Objects.requireNonNull(projectEditingContextService);
    }

    public void onApplicationEvent(BaselineDeleted event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Received TagDeleted %s", event));
        }
        fr.obeo.perseus.server.versioning.api.DeleteBaselineInput versioningInput = (fr.obeo.perseus.server.versioning.api.DeleteBaselineInput)event.getSource();
        DeleteBaselineInput appInput = (DeleteBaselineInput)versioningInput.causedBy();
        String projectId = appInput.projectId();
        long modelId = appInput.modelId();
        this.projectEditingContextService.getEditingContextId(projectId).ifPresent(editingContextId -> this.editingContextDispatcher.dispatchMutation(editingContextId, (IInput)new BaselineDeletedInput(versioningInput.id(), modelId, event.getBaselineId())));
        this.editingContextDispatcher.dispatchMutation(appInput.editingContextId(), (IInput)new BaselineDeletedInput(versioningInput.id(), modelId, event.getBaselineId()));
        this.projectEditingContextService.getEditingContextId(projectId).filter(editingContextId -> !editingContextId.equals(appInput.editingContextId())).ifPresent(editingContextId -> this.editingContextDispatcher.dispatchMutation(editingContextId, (IInput)new BaselineDeletedInput(versioningInput.id(), modelId, event.getBaselineId())));
    }
}

