/***********************************************************************************************
 * Copyright (c) 2023 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
export interface GQLOAuthFriend {
    name: string;
    key: string;
    rootServicesURI: string;
    type: string;
}
export interface GQLFriendDescriptor {
    name: string;
    key: string;
}
export interface GQLOAuthConsumer {
    key: string;
    name: string;
    provisional: boolean;
    trusted: boolean;
}
export interface GQLFriendAuthProblem {
    friendDescriptor: GQLFriendDescriptor;
}
export interface GQLFriendAuthProblemPayload extends GQLFriendAuthProblem {
    __typename: string;
}
export type HandleFriendAuthProblemEvent = {
    type: 'HANDLE_FRIEND_AUTH_PROBLEM';
    friendAuthProblemPayload: GQLFriendAuthProblemPayload;
};
export declare const isFriendAuthProblemPayload: (payload: {
    __typename: string;
}) => payload is GQLFriendAuthProblemPayload;
export interface GQLOAuthProblem extends GQLFriendAuthProblem {
    userAuthorizationURL: string;
}
export interface GQLOAuthProblemPayload extends GQLOAuthProblem, GQLFriendAuthProblemPayload {
}
export declare const isOAuthProblemPayload: (payload: {
    __typename: string;
}) => payload is GQLOAuthProblemPayload;
export interface GQLBasicAuthProblem extends GQLFriendAuthProblem {
    realm: string;
}
export interface GQLBasicAuthProblemPayload extends GQLBasicAuthProblem, GQLFriendAuthProblemPayload {
}
export declare const isBasicAuthProblemPayload: (payload: {
    __typename: string;
}) => payload is GQLBasicAuthProblemPayload;
export interface GQLApiKeyAuthProblem extends GQLFriendAuthProblem {
    hostName: string;
}
export interface GQLApiKeyAuthProblemPayload extends GQLApiKeyAuthProblem, GQLFriendAuthProblemPayload {
}
export declare const isApiKeyAuthProblemPayload: (payload: {
    __typename: string;
}) => payload is GQLApiKeyAuthProblemPayload;
//# sourceMappingURL=OAuth.types.d.ts.map