import { GQLUpdateOAuthRequestTokenMutationData } from './OAuthRequestTokenForm.types';
export interface OAuthRequestTokenFormStateSchema {
    states: {
        tokenForm: {
            states: {
                pristine: {};
                updatingToken: {};
                tokenAuthorized: {};
                tokenRejected: {};
                invalid: {};
            };
        };
    };
}
export type SchemaValue = {
    tokenForm: 'pristine' | 'updatingToken' | 'tokenAuthorized' | 'tokenRejected' | 'invalid';
};
export interface OAuthRequestTokenFormContext {
    callbackURI: string | null;
    message: string | null;
}
export type SetMessageEvent = {
    type: 'SET_MESSAGE';
    message: string;
};
export type ClearMessageEvent = {
    type: 'CLEAR_MESSAGE';
};
export type UpdateTokenEvent = {
    type: 'UPDATE_TOKEN';
};
export type HandleUpdatedTokenEvent = {
    type: 'HANDLE_UPDATED_TOKEN';
    data: GQLUpdateOAuthRequestTokenMutationData;
};
export type OAuthRequestTokenFormEvent = UpdateTokenEvent | HandleUpdatedTokenEvent | SetMessageEvent | ClearMessageEvent;
export declare const oauthRequestTokenFormMachine: import("xstate").StateMachine<OAuthRequestTokenFormContext, OAuthRequestTokenFormStateSchema, OAuthRequestTokenFormEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, OAuthRequestTokenFormEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=OAuthRequestTokenFormMachine.d.ts.map