import { GQLFriendAuthProblemPayload, HandleFriendAuthProblemEvent } from '../oauth/OAuth.types';
import { GQLOslcAssociation, GQLOslcDialog, GQLOslcType } from './Oslc.types';
import { GQLGetOslcAssociationsMutationData } from './OslcDialogSelector.types';
export interface OslcDialogSelectorStateSchema {
    states: {
        oslcDialogSelector: {
            states: {
                idle: {};
                loading: {};
                retrying: {};
            };
        };
    };
}
export type SchemaValue = {
    oslcDialogSelector: 'idle' | 'loading' | 'retrying';
};
export interface OslcDialogSelectorContext {
    resourceTypes: GQLOslcType[] | undefined;
    oslcAssociations: GQLOslcAssociation[];
    selectionDialogs: GQLOslcDialog[];
    creationDialogs: GQLOslcDialog[];
    selectedAssociation: GQLOslcAssociation | null;
    selectedDialog: GQLOslcDialog | null;
    friendAuthProblemPayload: GQLFriendAuthProblemPayload | null;
}
export type UpdateResourceTypesEvent = {
    type: 'UPDATE_RESOURCE_TYPES';
    resourceTypes: GQLOslcType[];
};
export type FetchOslcAssociationsEvent = {
    type: 'FETCH_OSLC_ASSOCIATIONS';
};
export type SelectOslcAssociationEvent = {
    type: 'SELECT_ASSOCIATION';
    selectedAssociation: GQLOslcAssociation | null;
};
export type SelectOslcDialogEvent = {
    type: 'SELECT_DIALOG';
    selectedDialog: GQLOslcDialog | null;
};
export type HandleFetchedOslcAssociationsEvent = {
    type: 'HANDLE_FETCHED_DATA';
    data: GQLGetOslcAssociationsMutationData;
};
export type OslcDialogSelectorEvent = UpdateResourceTypesEvent | FetchOslcAssociationsEvent | SelectOslcAssociationEvent | SelectOslcDialogEvent | HandleFriendAuthProblemEvent | HandleFetchedOslcAssociationsEvent;
export declare const oslcDialogSelectorMachine: import("xstate").StateMachine<OslcDialogSelectorContext, OslcDialogSelectorStateSchema, OslcDialogSelectorEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, OslcDialogSelectorEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=OslcDialogSelectorMachine.d.ts.map