import { GQLOAuthConsumer } from '../../core/oauth/OAuth.types';
import { GQLGetConsumersQueryData } from './ConsumersView.types';
export interface ConsumersViewStateSchema {
    states: {
        consumersView: {
            states: {
                loading: {};
                loaded: {};
                empty: {};
            };
        };
    };
}
export type SchemaValue = {
    consumersView: 'loading' | 'loaded' | 'empty';
};
export interface ConsumersViewContext {
    consumers: GQLOAuthConsumer[];
}
export type HandleFetchedConsumersEvent = {
    type: 'HANDLE_FETCHED_CONSUMERS';
    data: GQLGetConsumersQueryData;
};
export type ConsumersViewEvent = HandleFetchedConsumersEvent;
export declare const consumersViewMachine: import("xstate").StateMachine<ConsumersViewContext, ConsumersViewStateSchema, HandleFetchedConsumersEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, HandleFetchedConsumersEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=ConsumersViewMachine.d.ts.map