import { GQLOAuthConsumer } from '../../core/oauth/OAuth.types';
import { GQLGetConsumerQueryData, GQLUpdateConsumerMutationData } from './EditConsumerView.types';
export interface ConsumerViewStateSchema {
    states: {
        consumerView: {
            states: {
                loading: {};
                pristine: {};
                valid: {};
                invalid: {};
                updatingConsumer: {};
                missing: {};
                deleted: {};
            };
        };
    };
}
export type SchemaValue = {
    consumerView: 'loading' | 'pristine' | 'valid' | 'invalid' | 'missing' | 'updatingConsumer' | 'deleted';
};
export type EditConsumersViewModal = 'Delete';
export interface ConsumerViewContext {
    consumer: GQLOAuthConsumer | null;
    name: string | null;
    trusted: boolean | null;
    provisional: boolean;
    nameMessage: string;
    nameIsInvalid: boolean;
    modalToDisplay: EditConsumersViewModal | null;
}
export type ChangeEvent = {
    type: 'CHANGE';
    consumer: GQLOAuthConsumer | null;
    name: string | null;
    trusted: boolean | null;
    provisional: boolean;
};
export type ResetEvent = {
    type: 'RESET';
    consumer: GQLOAuthConsumer;
};
export type HandleFetchedConsumerEvent = {
    type: 'HANDLE_FETCHED_CONSUMER';
    data: GQLGetConsumerQueryData;
};
export type HandleUpdatedConsumerEvent = {
    type: 'HANDLE_UPDATED_CONSUMER';
    data: GQLUpdateConsumerMutationData;
};
export type UpdateConsumerEvent = {
    type: 'UPDATE_CONSUMER';
};
export type OpenModalEvent = {
    type: 'OPEN_MODAL';
    modalToDisplay: EditConsumersViewModal;
};
export type CancelModalEvent = {
    type: 'CANCEL_MODAL';
};
export type CloseModalEvent = {
    type: 'CLOSE_MODAL';
};
export type ConsumerViewEvent = ChangeEvent | ResetEvent | HandleFetchedConsumerEvent | HandleUpdatedConsumerEvent | UpdateConsumerEvent | OpenModalEvent | CancelModalEvent | CloseModalEvent;
export declare const consumerViewMachine: import("xstate").StateMachine<ConsumerViewContext, ConsumerViewStateSchema, ConsumerViewEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, ConsumerViewEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=EditConsumerViewMachine.d.ts.map