import { GQLBaseline, GQLCommit } from '../../core/Versioning.types';
export interface HistoryStateSchema {
    states: {
        history: {
            states: {
                loading: {};
                loaded: {};
            };
        };
    };
}
export type SchemaValue = {
    history: 'loading' | 'loaded';
};
export interface HistoryContext {
    id: string;
    currentRepresentationId: string | undefined;
    maxVersion: number | undefined;
    commits: GQLCommit[];
    baselines: GQLBaseline[];
}
export type HandleFetchedDataEvent = {
    type: 'HANDLE_FETCHED_DATA';
    fetchedCommits: GQLCommit[];
    fetchedBaselines: GQLBaseline[];
};
export type HandleBaselineCreatedEvent = {
    type: 'HANDLE_BASELINE_CREATED';
    baseline: GQLBaseline;
};
export type HandleBaselineDeletedEvent = {
    type: 'HANDLE_BASELINE_DELETED';
    baselineId: string;
};
export type HandleNewCommitEvent = {
    type: 'HANDLE_NEW_COMMIT';
    commit: GQLCommit;
};
export type SwitchRepresentationEvent = {
    type: 'SWITCH_REPRESENTATION';
    representationId: string;
};
export type FetchMoreCommitsEvent = {
    type: 'FETCH_MORE_COMMITS';
};
export type HistoryEvent = HandleFetchedDataEvent | HandleNewCommitEvent | HandleBaselineCreatedEvent | HandleBaselineDeletedEvent | SwitchRepresentationEvent | FetchMoreCommitsEvent;
export declare const historyMachine: import("xstate").StateMachine<HistoryContext, HistoryStateSchema, HistoryEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, HistoryEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=HistoryMachine.d.ts.map