import { GQLGetJobsQueryData, GQLJob } from './JobsView.types';
export interface JobsViewStateSchema {
    states: {
        jobsView: {
            states: {
                loading: {};
                loaded: {};
                empty: {};
            };
        };
    };
}
export type SchemaValue = {
    jobsView: 'loading' | 'loaded' | 'empty';
};
export interface JobsViewContext {
    jobs: GQLJob[];
}
export type HandleFetchedJobsEvent = {
    type: 'HANDLE_FETCHED_JOBS';
    data: GQLGetJobsQueryData;
};
export type JobsViewEvent = HandleFetchedJobsEvent;
export declare const jobsViewMachine: import("xstate").StateMachine<JobsViewContext, JobsViewStateSchema, HandleFetchedJobsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, HandleFetchedJobsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=JobsViewMachine.d.ts.map