/***********************************************************************************************
 * Copyright (c) 2025 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { Selection } from '@eclipse-sirius/sirius-components-core';
import { GQLFriendAuthProblemPayload } from '../../../core/oauth/OAuth.types';
import { GQLExtAttachmentArtifactDescriptor, GQLExtAttachmentDescriptor } from '../Model.types';
export declare type UnsynchronizedAttachmentsTableProps = {
    readOnly: boolean;
    unsynchronizedAttachments: GQLExtAttachmentDescriptor[];
    unsynchronizedAttachmentArtifacts: GQLExtAttachmentArtifactDescriptor[];
    editingContextId: string;
    projectId: string;
    modelId: number;
    configurationUri: string | null;
    setSelection: (selection: Selection) => void;
    displayPreviews: boolean;
};
export interface Action {
    type: 'RETRY' | 'DELETE' | 'RETRY_ALL' | 'DELETE_ALL';
    confirmation?: Confirmation;
    friendAuthProblemPayload?: GQLFriendAuthProblemPayload;
    attachmentId?: string;
    attachmentArtifactId?: string;
}
export interface Confirmation {
    title: string;
    message: string;
}
//# sourceMappingURL=UnsynchronizedAttachmentsTable.types.d.ts.map