/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { RepresentationComponentProps } from '@eclipse-sirius/sirius-components-core';
import { GQLExtConfiguration } from '../../core/oslc/globalconf/GlobalConf.types';
export interface ModelObjectComponentProps extends RepresentationComponentProps {
    mode?: string;
}
export interface GQLModelObjectEventSubscription {
    modelObjectEvent: GQLModelObjectEventPayload;
}
export interface GQLModelObjectEventPayload {
    __typename: string;
}
export interface GQLModelObjectRefreshedEventPayload extends GQLModelObjectEventPayload {
    id: string;
    summary: GQLModelObjectSummary;
}
export interface GQLModelObjectSummary {
    id: string;
    projectId: string;
    modelUid: string;
    name: string;
    type: GQLMetaclassRef;
    description: string;
    imageURL: string;
    objectDiagram?: GQLModelDiagram;
    modelAssignedGlobalConf?: GQLExtConfiguration;
}
export interface GQLMetaclassRef {
    name: string;
    nsUri: string;
}
export interface GQLModelDiagram {
    imageURL: string;
    width: number;
    height: number;
    imageMap: GQLImageMapArea[];
}
export type GQLImageMapArea = {
    shape: string;
    coords: number[];
    uris: string[];
};
export type GQLGetProjectQueryData = {
    viewer: GQLViewer;
};
export type GQLGetProjectQueryVariables = {
    projectId: string;
};
export interface GQLViewer {
    project: GQLProject;
}
export interface GQLProject {
    globalConf: boolean;
    currentUserGlobalConf?: GQLExtConfiguration;
}
//# sourceMappingURL=ModelObject.types.d.ts.map