/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { SubscriptionResult } from '@apollo/client';
import { GQLModelObjectEventSubscription, GQLModelObjectSummary } from './ModelObject.types';
export interface ModelObjectStateSchema {
    states: {
        modelObject: {
            states: {
                loading: {};
                loaded: {};
                complete: {};
            };
        };
    };
}
export type SchemaValue = {
    modelObject: 'loading' | 'loaded' | 'complete';
};
export interface ModelObjectContext {
    id: string;
    currentRepresentationId: string | null;
    summary: GQLModelObjectSummary | null;
}
export type SwitchRepresentationEvent = {
    type: 'SWITCH_REPRESENTATION';
    representationId: string;
};
export type HandleDataEvent = {
    type: 'HANDLE_DATA';
    data: SubscriptionResult<GQLModelObjectEventSubscription>;
};
export type HandleCompleteEvent = {
    type: 'HANDLE_COMPLETE';
};
export type ModelObjectEvent = SwitchRepresentationEvent | HandleDataEvent | HandleCompleteEvent;
export declare const modelObjectMachine: import("xstate").StateMachine<ModelObjectContext, ModelObjectStateSchema, ModelObjectEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, ModelObjectEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=ModelObjectMachine.d.ts.map