import { GQLOslcAssociationDescriptor, GQLOslcLinking } from '../../../../core/oslc/Oslc.types';
import { GQLGetProjectQueryData } from './OslcWidget.types';
export interface OslcWidgetStateSchema {
    states: {
        oslcWidget: {
            states: {
                loading: {};
                loaded: {};
                creatingLink: {};
                deletingLink: {};
            };
        };
    };
}
export type SchemaValue = {
    oslcWidget: 'loading' | 'loaded' | 'creatingLink' | 'deletingLink';
};
export type DeletedLink = {
    url: string;
    label: string;
};
export interface OslcWidgetContext {
    deletedLink: DeletedLink | null;
    oslcAssociations: GQLOslcAssociationDescriptor[];
    oslcLinkings: GQLOslcLinking[];
}
export type HandleFetchedProjectEvent = {
    type: 'HANDLE_FETCHED_PROJECT';
    data: GQLGetProjectQueryData;
};
export type CreateLinkEvent = {
    type: 'CREATE_LINK';
};
export type DeleteLinkEvent = {
    type: 'DELETE_LINK';
    linkId: string;
};
export type HandleCreatedLinkEvent = {
    type: 'HANDLE_CREATED_LINK';
};
export type HandleDeletedLinkEvent = {
    type: 'HANDLE_DELETED_LINK';
};
export type HandleDeleteLinkErrorEvent = {
    type: 'HANDLE_DELETE_LINK_ERROR';
};
export type CloseDeleteWarningEvent = {
    type: 'CLOSE_DELETE_WARNING';
};
export type HandlePartialDeleteLinkEvent = {
    type: 'HANDLE_PARTIAL_DELETE_LINK';
    url: string;
    label: string;
};
export type OslcWidgetEvent = HandleFetchedProjectEvent | CreateLinkEvent | DeleteLinkEvent | HandlePartialDeleteLinkEvent | CloseDeleteWarningEvent | HandleCreatedLinkEvent | HandleDeletedLinkEvent | HandleDeleteLinkErrorEvent;
export declare const oslcWidgetMachine: import("xstate").StateMachine<OslcWidgetContext, OslcWidgetStateSchema, OslcWidgetEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, OslcWidgetEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=OslcWidgetMachine.d.ts.map