import { GQLOAuthFriend } from '../../../core/oauth/OAuth.types';
import { GQLOslcAssociationDescriptor } from '../../../core/oslc/Oslc.types';
import { GQLCreateOslcAssociationMutationData, GQLGetProjectQueryData, GQLProject } from './ProjectSettingsOslcAssociationsView.types';
export interface ProjectSettingsOslcAssociationsStateSchema {
    states: {
        projectSettingsOslcAssociations: {
            states: {
                loading: {};
                loaded: {};
                missing: {};
                empty: {};
            };
        };
    };
}
export type SchemaValue = {
    projectSettingsOslcAssociations: 'loading' | 'loaded' | 'missing' | 'empty';
};
export interface ProjectSettingsOslcAssociationsContext {
    project: GQLProject | null;
    oauthFriends: GQLOAuthFriend[];
    associationToDelete: GQLOslcAssociationDescriptor | null;
}
export type HandleFetchedProjectEvent = {
    type: 'HANDLE_FETCHED_PROJECT';
    data: GQLGetProjectQueryData;
};
export type HandleCreatedAssociationEvent = {
    type: 'HANDLE_CREATED_ASSOCIATION';
    data: GQLCreateOslcAssociationMutationData;
};
export type OpenConfirmationDialogEvent = {
    type: 'OPEN_CONFIRMATION_DIALOG';
    associationToDelete: GQLOslcAssociationDescriptor;
};
export type CloseConfirmationDialogEvent = {
    type: 'CLOSE_CONFIRMATION_DIALOG';
};
export type HandleDeletedAssociationEvent = {
    type: 'HANDLE_DELETED_ASSOCIATION';
    deletedAssociation: GQLOslcAssociationDescriptor;
};
export type ProjectSettingsOslcAssociationsEvent = OpenConfirmationDialogEvent | CloseConfirmationDialogEvent | HandleFetchedProjectEvent | HandleCreatedAssociationEvent | HandleDeletedAssociationEvent;
export declare const projectSettingsOslcAssociationsMachine: import("xstate").StateMachine<ProjectSettingsOslcAssociationsContext, ProjectSettingsOslcAssociationsStateSchema, ProjectSettingsOslcAssociationsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, ProjectSettingsOslcAssociationsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=ProjectSettingsOslcAssociationsViewMachine.d.ts.map